/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.dao.BasAccountBaccountDao;
import com.guochuang.imp.base.entity.BasAccountBaccount;
import com.guochuang.imp.base.entity.BasBankAccount;
import com.guochuang.imp.base.service.CommonService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasAccountBaccountService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasAccountBaccountDao basaccountbaccountDao;

    public BasAccountBaccount findBasAccountBaccount(Long id) {
        BasAccountBaccount entity = (BasAccountBaccount)this.basaccountbaccountDao.findById(id).get();
        return entity;
    }

    public void saveBasAccountBaccount(BasAccountBaccount entity) {
        this.basaccountbaccountDao.save(entity);
    }

    public void saveBasAccountBaccount(String updated, BasBankAccount account) {
        if (!StringUtils.isEmpty((String)updated)) {
            JSONArray listUpdated = JSON.parseArray((String)updated);
            for (Object o : listUpdated) {
                Map row = (Map)o;
                BasAccountBaccount entity = new BasAccountBaccount();
                entity.setBankAccountId(account.getBankAccountId());
                entity.setIsUse("Y");
                entity.setModifyAccount(account.getModifyAccount());
                entity.setModifyTime(new Date());
                if (row.get("ACCOUNT_BACCOUNT_ID") != null) {
                    entity.setAccountBaccountId(Long.parseLong(row.get("ACCOUNT_BACCOUNT_ID").toString()));
                }
                if (row.get("BANK_ACCOUNT_ID") != null) {
                    entity.setBankAccountId(Long.parseLong(row.get("BANK_ACCOUNT_ID").toString()));
                }
                if (row.get("ACCOUNT_ID") != null) {
                    entity.setAccountId(Long.parseLong(row.get("ACCOUNT_ID").toString()));
                }
                if (row.get("PK_SUBJTYPE") != null) {
                    entity.setPkSubjtype(row.get("PK_SUBJTYPE").toString());
                }
                if (row.get("REMARK") != null) {
                    entity.setRemark(row.get("REMARK").toString());
                }
                this.basaccountbaccountDao.save(entity);
            }
        }
    }

    public void delBasAccountBaccount(Long id, Long userId) {
        BasAccountBaccount entity = (BasAccountBaccount)this.basaccountbaccountDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyAccount(userId);
        entity.setModifyTime(new Date());
        this.basaccountbaccountDao.save(entity);
    }

    public List<?> queryByBankAccount(Long bankAccountId) {
        if (bankAccountId == null) {
            String sql = "select t.subjtypename,t.PK_SUBJTYPE  from B_FM_ACCOUNT_TYPE t  where t.group_index = 0 and t.subjtypename in ('\u8d44\u4ea7', '\u8d1f\u503a')";
            return this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.subjtypename,a.Dispname ACCOUNT_ID_TEXT_,t.PK_SUBJTYPE,b.account_baccount_id,b.bank_account_id,b.account_id,b.remark,b.modify_account\n");
        sql.append("  from B_FM_ACCOUNT_TYPE t\n");
        sql.append("  left join BAS_ACCOUNT_BACCOUNT b\n");
        sql.append("  on b.pk_subjtype=t.pk_subjtype and b.bank_account_id=:bankAccountId and b.is_use=:isUse\n");
        sql.append("  left join BAS_ACCOUNT a \n");
        sql.append("  on b.account_id=a.account_id\n");
        sql.append(" where t.group_index = 0\n");
        sql.append("   and t.subjtypename in ('\u8d44\u4ea7', '\u8d1f\u503a')");
        params.put("isUse", "Y");
        params.put("bankAccountId", bankAccountId);
        sql.append(" order by t.pk_subjtype");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), params, new int[0]);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(list, dicmapper);
        return list;
    }
}

