/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.spring.SystemControllerLog;
import com.guochuang.imp.base.common.util.GenerateRandomKeyUtil;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasEmp;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasEmpService;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.util.StringUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/saLogin"})
public class SaLoginController
extends BaseController {
    private static Logger loger = LoggerFactory.getLogger(SaLoginController.class);
    @Autowired
    private BasEmpService basEmpService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private CommonService commonService;
    private static String serverUrl;
    private static String client_id;
    private static String client_secret;

    public static String getServerUrl() {
        return serverUrl;
    }

    @Value(value="${saLogin.serverUrl}")
    public void setServerUrl(String serverUrl) {
        SaLoginController.serverUrl = serverUrl;
    }

    public static String getClient_id() {
        return client_id;
    }

    @Value(value="${saLogin.client_id}")
    public void setClient_id(String client_id) {
        SaLoginController.client_id = client_id;
    }

    public static String getClient_secret() {
        return client_secret;
    }

    @Value(value="${saLogin.client_secret}")
    public void setClient_secret(String client_secret) {
        SaLoginController.client_secret = client_secret;
    }

    public static void main(String[] args) {
        SaLoginController.test();
    }

    public static String getToken() {
        try {
            String res = SysUtils.sendPostHttp(serverUrl + "/api/getAuthToken?client_id=" + client_id + "&client_secret=" + client_secret);
            JSONObject json = JSONObject.parseObject((String)res);
            loger.info("\u83b7\u53d6token\u8fd4\u56de\u7ed3\u679c: " + res);
            return json.getString("data");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void test() {
        String token = SaLoginController.getToken();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String res = SaLoginController.sendPostHttp(serverUrl + "/api/deleteTask", token, params);
            loger.info("getOrgList\u8fd4\u56de\u7ed3\u679c: " + res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String sendPostHttp(String urlstr, String token, Map<String, String> parameters) throws Exception {
        String string;
        URL url = new URL(urlstr);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("POST");
        urlConnection.setRequestProperty("authToken", token);
        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        urlConnection.setRequestProperty("Accept-Charset", "UTF-8");
        urlConnection.setRequestProperty("Connection", "Keep-Alive");
        StringBuilder postData = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (postData.length() != 0) {
                postData.append('&');
            }
            postData.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        urlConnection.setUseCaches(false);
        urlConnection.setDoOutput(true);
        Throwable throwable = null;
        try (OutputStream os = urlConnection.getOutputStream();){
            byte[] input = postData.toString().getBytes("UTF-8");
            os.write(input, 0, input.length);
        }
        catch (Throwable input) {
            Throwable throwable2 = input;
            throw input;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
        StringBuilder allLines = new StringBuilder();
        while ((string = reader.readLine()) != null) {
            allLines.append(string);
        }
        reader.close();
        urlConnection.disconnect();
        return allLines.toString();
    }

    @RequestMapping(value={"/login"})
    @SystemControllerLog(description="\u6388\u6743\u7801\u767b\u5f55")
    public ModelAndView codeLogin(HttpSession session, HttpServletRequest request, String accessToken, String url) {
        ModelAndView view = new ModelAndView();
        request.getSession().setAttribute("sessionSalt", (Object)GenerateRandomKeyUtil.getRandomKey(16));
        view.setViewName("index");
        try {
            String userInfo = SysUtils.sendPostHttp(serverUrl + "/api/oauth2/userinfo?access_token=" + accessToken);
            JSONObject jsonuser = JSONObject.parseObject((String)userInfo);
            loger.info("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c: " + userInfo);
            String ucode = jsonuser.getString("code");
            if ("200".equals(ucode)) {
                String empNo = jsonuser.getString("empNo");
                List<BasEmpAccount> accountlist = this.basEmpAccountService.getAccountByEmpCode(empNo);
                if (accountlist != null && accountlist.size() > 0) {
                    LoginUser loginUser = new LoginUser();
                    BasEmpAccount account = accountlist.get(0);
                    Long loginAccountid = null;
                    if (account != null) {
                        loginAccountid = account.getAccountId();
                    }
                    BasEmp emp = this.basEmpService.findEmpByempId(account.getEmpId());
                    UsernamePasswordToken tokennew = new UsernamePasswordToken(loginAccountid.toString(), emp.getLoginPassword());
                    Subject currentUser = SecurityUtils.getSubject();
                    currentUser.login((AuthenticationToken)tokennew);
                    if (currentUser.isAuthenticated()) {
                        LoginUser oldloginUser = (LoginUser)session.getAttribute("LOGIN_USER");
                        if (oldloginUser != null) {
                            session.removeAttribute("LOGIN_USER");
                            CommonService.delOnlineUser(oldloginUser);
                            this.commonService.setLogOutLog(session.getId(), oldloginUser.getAccountid());
                        }
                        emp.setLockCount(0L);
                        emp.setLockTime(null);
                        this.basEmpService.saveEmp(emp);
                        String ip = SysUtils.getIpAddr(request);
                        loginUser = this.commonService.setSessionAndLogInLog(session, emp, loginAccountid, ip);
                        CommonService.addOnlineUser(loginUser);
                    } else {
                        tokennew.clear();
                    }
                    if (StringUtil.isNotEmpty(url)) {
                        view.setViewName("redirect:" + url);
                    } else {
                        view.setViewName("redirect:/");
                    }
                } else {
                    view.setViewName("redirect:/");
                }
            } else {
                loger.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + jsonuser.getString("msg"));
            }
        }
        catch (Exception e) {
            loger.error("\u83b7\u53d6token\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return view;
    }
}

