/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.CollectionUtils;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasDept;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.service.BasDeptService;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasRolesAccountService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basdept"})
public class BaseDeptController
extends BaseController {
    @Autowired
    private BasDeptService basDeptService;
    @Autowired
    private BasRolesAccountService basRolesAccountService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;

    @RequestMapping(value={"/queryDeptmenu"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptmenu(HttpServletRequest request, String pid, String orgId, @RequestParam(value="isTree", required=false, defaultValue="false") String isTree) {
        long searchPid = 0L;
        long searchOrgId = 0L;
        if (!StringUtils.isEmpty((Object)pid)) {
            searchPid = Long.parseLong(pid);
        }
        if (!StringUtils.isEmpty((Object)orgId)) {
            searchOrgId = Long.parseLong(orgId);
        } else {
            LoginUser user = this.getLoginUser(request);
            searchOrgId = user.getOrgid();
        }
        List<ComBoxTreeNode> deptlist = this.basDeptService.getDeptMenu(searchPid, searchOrgId);
        if ("true".equals(isTree)) {
            ComBoxTreeNode root = new ComBoxTreeNode();
            root.setId("0");
            root.setText("\u90e8\u95e8\u4f53\u7cfb");
            root.setChecked(false);
            root.setChildren(deptlist);
            ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
            list.add(root);
            return list;
        }
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptdefault"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptmenu() {
        long searchPid = 0L;
        long searchOrgId = 10001L;
        List<ComBoxTreeNode> deptlist = this.basDeptService.getDeptMenu(searchPid, searchOrgId);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptCombox"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptCombox(HttpServletRequest request, String deptLevel, @RequestParam(value="showBusinessUnit", defaultValue="false") boolean showBusinessUnit, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail) {
        LoginUser user = this.getLoginUser(request);
        Long searchOrgId = null;
        String orgId = request.getParameter("orgId");
        if (!isdetail && !StringUtils.isEmpty((Object)orgId)) {
            searchOrgId = Long.parseLong(orgId);
        } else if (!isdetail) {
            searchOrgId = user.getOrgid();
        }
        List<ComboxNode> deptlist = this.basDeptService.getDeptCombo(searchOrgId, deptLevel, showBusinessUnit);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptComboxAll"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptComboxAll(HttpServletRequest request, String deptLevel, @RequestParam(value="showBusinessUnit", defaultValue="false") boolean showBusinessUnit, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail) {
        LoginUser user = this.getLoginUser(request);
        Long searchOrgId = null;
        String orgId = request.getParameter("orgId");
        if (!isdetail && !StringUtils.isEmpty((Object)orgId)) {
            searchOrgId = Long.parseLong(orgId);
        } else if (!isdetail) {
            searchOrgId = user.getOrgid();
        }
        List<ComboxNode> deptlist = this.basDeptService.getDeptComboAll(searchOrgId, deptLevel, showBusinessUnit);
        return deptlist;
    }

    @RequestMapping(value={"/queryAllDept"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryAllDept(Long orgId) {
        List<ComboxNode> deptlist = this.basDeptService.getDeptCombo(orgId, null);
        return deptlist;
    }

    @RequestMapping(value={"/queryAllDeptAndAll"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryAllDeptAndAll(Long orgId) {
        List<ComboxNode> deptlist = this.basDeptService.getDeptComboAll(orgId);
        return deptlist;
    }

    @Deprecated
    @RequestMapping(value={"/queryDeptCombo"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptCombo(Long orgId, String deptLevel) {
        Long searchOrgId = SysContent.GROUP_ORG;
        if (orgId != null) {
            searchOrgId = orgId;
        }
        List<ComboxNode> deptlist = this.basDeptService.getDeptCombo(searchOrgId, deptLevel);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptInfo(String deptId) {
        BasDept entity = this.basDeptService.findByDeptId(Long.parseLong(deptId));
        return entity;
    }

    @RequestMapping(value={"/saveDept"})
    @ResponseBody
    public Object saveDept(BasDept basDept) {
        if (this.basDeptService.hasRepeat(basDept)) {
            return new JsonMsg(false, "\u90e8\u95e8\u540d\u79f0\u3001\u7f16\u7801\u548c\u7b80\u79f0\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u5f55\u5165");
        }
        return this.basDeptService.saveDept(basDept);
    }

    @RequestMapping(value={"/deleDept"}, method={RequestMethod.POST})
    @ResponseBody
    public Object deleDept(String deptId) {
        JsonMsg msg = new JsonMsg();
        BasDept basDept = this.basDeptService.findByDeptId(Long.parseLong(deptId));
        List<BasEmpAccount> list = this.basEmpAccountService.findByDeptId(Long.valueOf(deptId));
        if (CollectionUtils.isNotEmpty(list)) {
            msg.setMsg("\u90e8\u95e8\u5b58\u5728\u4eba\u5458\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
            msg.setSuccess(false);
            return msg;
        }
        basDept.setIsUse("N");
        msg = this.basDeptService.saveDept(basDept);
        return msg;
    }

    @RequestMapping(value={"/findArchivesDept"}, method={RequestMethod.POST})
    @ResponseBody
    public Object findArchivesDept() {
        return this.basDeptService.findArchivesDept();
    }

    @RequestMapping(value={"/deleDepts"}, method={RequestMethod.POST})
    @ResponseBody
    public Object deleOrgs(Long deptId) {
        if (this.basDeptService.delDepts(deptId)) {
            return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f");
        }
        return new JsonMsg(false, "\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/pageBasDept"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasDept(@RequestParam(value="orgId", defaultValue="0") Long orgId, Long bizOrgId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basDeptService.PageAll(orgId, bizOrgId, search, page, rows);
    }

    @RequestMapping(value={"/queryDeptComboxByOrgId"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptComboxByOrgId(HttpServletRequest request, String deptLevel, @RequestParam(value="showBusinessUnit", defaultValue="false") boolean showBusinessUnit, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail, Long orgId) {
        LoginUser user = this.getLoginUser(request);
        if (orgId == null) {
            ArrayList deptlist = new ArrayList();
            return deptlist;
        }
        if (isdetail) {
            orgId = null;
        }
        List<ComboxNode> deptlist = this.basDeptService.getDeptCombo(orgId, null, showBusinessUnit);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptAndOrgCombo"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptAndOrgCombo(Long deptId) {
        List<ComboxNode> deptlist = this.basDeptService.getComboxListForDeptAndOrg(deptId);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptAndOrgNameById"}, method={RequestMethod.POST})
    @ResponseBody
    public String queryDeptAndOrgNameById(Long id) {
        return this.basDeptService.queryDeptAndOrgNameById(id);
    }

    @RequestMapping(value={"/queryOrgDeptCombox"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryOrgDeptCombox(HttpServletRequest request, String deptLevel, @RequestParam(value="showBusinessUnit", defaultValue="false") boolean showBusinessUnit, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail) {
        String isAll = request.getParameter("isAll");
        LoginUser user = this.getLoginUser(request);
        Long searchOrgId = null;
        String orgId = request.getParameter("orgId");
        if (isdetail && !StringUtils.isEmpty((Object)orgId)) {
            searchOrgId = Long.parseLong(orgId);
        } else if (!isdetail) {
            searchOrgId = user.getOrgid();
        }
        List<ComboxNode> deptlist = this.basDeptService.queryOrgDeptCombox(searchOrgId, deptLevel, showBusinessUnit, isAll);
        return deptlist;
    }
}

