/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasSignature;
import com.guochuang.imp.base.service.BasSignatureService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasSignature"})
public class BasSignatureController
extends BaseController {
    @Autowired
    private BasSignatureService bassignatureService;

    @RequestMapping(value={"/pageBasSignature"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasSignature(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.bassignatureService.PageAll(search, page, rows, sort, order);
    }

    @RequestMapping(value={"/findBasSignature"})
    @ResponseBody
    public Object findBasSignature(Long id, boolean isdetail) {
        BasSignature entity = this.bassignatureService.findBasSignature(id, isdetail);
        return entity;
    }

    @RequestMapping(value={"/saveBasSignature"})
    @ResponseBody
    public Object saveBasSignature(HttpServletRequest request, BasSignature entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getSignatureId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.bassignatureService.saveBasSignature(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasSignature"})
    @ResponseBody
    public Object delBasSignature(Long id) {
        this.bassignatureService.delBasSignature(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/updateBasSignature"})
    @ResponseBody
    public JsonMsg updateBasSignature(Long id, String status) {
        BasSignature entity = this.bassignatureService.findBasSignature(id, false);
        entity.setStatus(status);
        if ("Y".equals(status)) {
            entity.setStartDate(new Date());
            Boolean flag = this.bassignatureService.checkIsHave(entity);
            if (flag.booleanValue()) {
                return new JsonMsg(false, "\u5df2\u5b58\u5728\u6388\u6743\u7684\u4eba\u5458");
            }
        } else {
            entity.setEndDate(new Date());
        }
        this.bassignatureService.saveBasSignature(entity);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/checkSignPerm"})
    @ResponseBody
    public JsonMsg checkSignPerm(Long accountId) {
        if (accountId == null) {
            accountId = SysUtils.getLoginAccountId();
        }
        Boolean flag = this.bassignatureService.findByAccountId(accountId);
        return new JsonMsg(flag, "");
    }
}

