/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.ComboxCheckNode;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.ComboxUtils;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasOrg;
import com.guochuang.imp.base.req.GetBasOrgCombotreeReq;
import com.guochuang.imp.base.service.BasOrgService;
import com.guochuang.imp.base.service.ViewBasOrgDeptService;
import com.guochuang.imp.doc.common.util.FileStoreException;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basorg"})
public class BasOrgController
extends BaseController {
    @Autowired
    private BasOrgService basOrgService;
    @Autowired
    private ViewBasOrgDeptService viewbasorgdeptService;

    @RequestMapping(value={"/getOrgDeptTree"})
    @ResponseBody
    public Object getOrgDeptTree(@RequestParam(value="pid", defaultValue="0") Long pid, String detailId, Integer level, @RequestParam(value="fullName", defaultValue="false") boolean fullName, @RequestParam(value="showDept", defaultValue="false") boolean showDept, @RequestParam(value="withLogin", defaultValue="false") boolean withLogin, @RequestParam(value="withOut", defaultValue="false") boolean withOut, @RequestParam(value="withSelf", defaultValue="true") boolean withSelf, @RequestParam(value="showCancel", defaultValue="false") boolean showCancel) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            String[] ids = detailId.split(",");
            String orgName = "";
            for (String id : ids) {
                BasOrg org = this.basOrgService.findByOrgId(Long.parseLong(id));
                if (org == null) continue;
                orgName = orgName + "," + (fullName ? org.getOrgName() : org.getAbbr());
            }
            if (StringUtils.isNotBlank((String)orgName)) {
                orgName = orgName.substring(1);
            }
            root.setId(detailId.toString());
            root.setText(orgName);
            root.setChecked(true);
            list.add(root);
            return list;
        }
        List<ComBoxTreeNode> treelist = this.basOrgService.getOrgDeptTree(fullName, showDept, level, withLogin, withOut, withSelf, pid, showCancel);
        return treelist;
    }

    @RequestMapping(value={"/getOrgDeptComb"})
    @ResponseBody
    public Object getOrgDeptComb(@RequestParam(value="pid", defaultValue="0") Long pid, String detailId, Integer level, @RequestParam(value="fullName", defaultValue="false") boolean fullName, @RequestParam(value="showDept", defaultValue="false") boolean showDept, @RequestParam(value="withLogin", defaultValue="false") boolean withLogin, @RequestParam(value="withOut", defaultValue="false") boolean withOut, @RequestParam(value="withEmpty", defaultValue="false") boolean withEmpty, @RequestParam(value="withSelf", defaultValue="true") boolean withSelf, @RequestParam(value="showCancel", defaultValue="false") boolean showCancel) {
        return this.basOrgService.getOrgDeptComb(fullName, showDept, level, withLogin, withOut, withEmpty, withSelf, pid, showCancel);
    }

    @RequestMapping(value={"/queryOrgTreeReal"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryOrgMenu(Long id, Long orgId) {
        if (id == null && orgId != null) {
            ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>(1);
            BasOrg org = this.basOrgService.findByOrgId(orgId);
            ComBoxTreeNode node = new ComBoxTreeNode();
            node.setId(org.getOrgId().toString());
            node.setText(org.getAbbr());
            node.addAttributes("orgCode", org.getOrgCode());
            node.setState("closed");
            list.add(node);
            return list;
        }
        if (id == null) {
            id = 0L;
        }
        return this.basOrgService.getOrgMenu(id);
    }

    @RequestMapping(value={"/queryOrgTreeRealNew"})
    @ResponseBody
    public Object queryOrgTreeRealNew(@RequestParam(value="pid", defaultValue="0") Long pid, String detailId, String type, String showFullName, @RequestParam(value="showCancel", defaultValue="N") String showCancel) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            String[] ids = detailId.split(",");
            String orgName = "";
            for (String id : ids) {
                BasOrg org = this.basOrgService.findByOrgId(Long.parseLong(id));
                if (org == null) continue;
                orgName = orgName + "," + ("Y".equals(showFullName) ? org.getOrgName() : org.getAbbr());
            }
            if (StringUtils.isNotBlank((String)orgName)) {
                orgName = orgName.substring(1);
            }
            root.setId(detailId.toString());
            root.setText(orgName);
            root.setChecked(true);
            list.add(root);
            return list;
        }
        List<ComBoxTreeNode> treelist = this.basOrgService.treeBasOrg(pid, type, showFullName, showCancel);
        return treelist;
    }

    @Deprecated
    @RequestMapping(value={"/queryOrgTreeRealNewForTf"})
    @ResponseBody
    public Object queryOrgTreeRealNewForTf() {
        Long tfLong = 10000000L;
        List<ComBoxTreeNode> treelist = this.basOrgService.findBasOrgByOne(tfLong);
        return treelist;
    }

    @RequestMapping(value={"/constructOrgAndFirstDept"})
    @ResponseBody
    public List<Map<String, Object>> constructOrgAndFirstDept() {
        return this.basOrgService.constructOrgAndFirstDept();
    }

    @RequestMapping(value={"/findAssessmentOrg"})
    @ResponseBody
    @Deprecated
    public List<ComboxNode> findAssessmentOrg() {
        return this.basOrgService.findAssessmentOrg();
    }

    @RequestMapping(value={"/queryOrgmenu"}, method={RequestMethod.POST})
    @ResponseBody
    @Deprecated
    public Object queryOrgmenu(String detailId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basOrgService.getOrgTree(true);
    }

    @Deprecated
    @RequestMapping(value={"/queryOrgTree"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryOrgTree(String detailId, boolean isContainOutside) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basOrgService.getOrgTree(isContainOutside);
    }

    @RequestMapping(value={"/queryOrgAndDeptTree"})
    @ResponseBody
    public Object queryOrgAndDeptTree(String id, HttpServletRequest request, String detailId, String orgId, String type, @RequestParam(value="showCancel", defaultValue="N") String showCancel) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgDeptName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        String parameter = request.getParameter("excludeExternal");
        String deptId = request.getParameter("deptId");
        if (StringUtils.isNotBlank((String)parameter)) {
            return this.basOrgService.queryOrgAndDeptTreeExcludeExternal(StringUtils.isNotBlank((String)orgId) ? orgId : "0", deptId);
        }
        return this.basOrgService.queryOrgAndDeptTree(id, orgId, type, showCancel);
    }

    @RequestMapping(value={"/queryOrgAndDeptTreeQx"})
    @ResponseBody
    public Object queryOrgAndDeptTreeQx(String id, HttpServletRequest request, String detailId, String orgId) {
        LoginUser loginUser = this.getLoginUser(request);
        orgId = String.valueOf(loginUser.getOrgid());
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgDeptName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basOrgService.queryOrgAndDeptTreeQx(id, orgId);
    }

    @RequestMapping(value={"/queryOrgAndDeptTreeWithoutRoot"})
    @ResponseBody
    public Object queryOrgAndDeptTreeWithoutRoot(String id, HttpServletRequest request, String detailId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.viewbasorgdeptService.findById(Long.parseLong(detailId)).getText());
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basOrgService.queryOrgAndDeptTreeWithoutRoot(id);
    }

    @RequestMapping(value={"/queryOrgAndDeptTreeNew"})
    @ResponseBody
    public Object queryOrgAndDeptTreeNew(String id, HttpServletRequest request, String infoType) {
        Long orgId = this.getLoginUser(request).getOrgid();
        if (StringUtils.isNotBlank((String)infoType)) {
            return this.basOrgService.queryOrgAndDeptTreeNew1(id, orgId);
        }
        return this.basOrgService.queryOrgAndDeptTreeNew(String.valueOf(orgId));
    }

    @RequestMapping(value={"/queryOrgAndDeptTreeByOrg"})
    @ResponseBody
    public Object queryOrgAndDeptTreeByOrg(String id, HttpServletRequest request) {
        Long orgId = this.getLoginUser(request).getOrgid();
        return this.basOrgService.queryOrgAndDeptTreeByOrg(id, orgId);
    }

    @RequestMapping(value={"/pageBasOrg"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasOrg(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.basOrgService.PageAll(search, page, rows, sort, order);
    }

    @RequestMapping(value={"/pageBasOrgSelect"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasOrgSelect() {
        return this.basOrgService.allEasOrg();
    }

    @RequestMapping(value={"/queryOrgInfo"})
    @ResponseBody
    public Object queryOrgInfo(String orgId) throws FileStoreException {
        return this.basOrgService.findByOrgId(Long.parseLong(orgId));
    }

    @RequestMapping(value={"/longUserOrgAndDeptTree"})
    @ResponseBody
    @Deprecated
    public Object longUserOrgAndDeptTree(HttpServletRequest request, String detailId, String type, @RequestParam(value="showCancel", defaultValue="N") String showCancel) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgDeptName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basOrgService.queryOrgAndDeptTree(this.getLoginUser(request).getOrgid().toString(), null, type, showCancel);
    }

    @RequestMapping(value={"/longUserOrgAndDeptTreeForContact"})
    @ResponseBody
    public Object longUserOrgAndDeptTreeForContact(HttpServletRequest request, String detailId, String id) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgDeptName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basOrgService.queryOrgAndDeptTreeForContact(id);
    }

    @RequestMapping(value={"/queryEmpOrgTree"})
    @ResponseBody
    public Object queryEmpOrgTree(Long id, String showCancel, String nameSort, HttpServletRequest request) {
        if (id == null) {
            id = SysUtils.getLoginUser().getOrgid();
        }
        return this.basOrgService.queryEmpOrgTree(id, showCancel, nameSort);
    }

    @RequestMapping(value={"/queryEmpOrgTreeForTime"})
    @ResponseBody
    public Object queryEmpOrgTreeForTime(Long pid, String showCancel, String nameSort, HttpServletRequest request) {
        return this.basOrgService.queryEmpOrgTreeForTime(pid, showCancel, nameSort);
    }

    @RequestMapping(value={"/queryEmpOrgTreeForTimeMultiJob"})
    @ResponseBody
    public Object queryEmpOrgTreeForTimeMultiJob(Long pid, String showCancel, String nameSort, HttpServletRequest request) {
        return this.basOrgService.queryEmpOrgTreeForTimeMultiJob(pid, showCancel, nameSort);
    }

    @RequestMapping(value={"/queryOrgTreeMap"})
    @ResponseBody
    public Object queryOrgTreeMap(Long id, HttpServletRequest request) {
        if (id == null) {
            id = SysUtils.getLoginUser().getOrgid();
        }
        return this.basOrgService.queryOrgTreeMap(id);
    }

    @RequestMapping(value={"/queryOrgAndDeptList"})
    @ResponseBody
    public Object queryOrgAndDeptList(String id, HttpServletRequest request) {
        List list = this.basOrgService.queryOrgAndDeptList(id);
        for (Object ob : list) {
            Map map = (Map)ob;
            if ("0".equals(map.get("PID").toString())) {
                map.put("_parentId", null);
                continue;
            }
            map.put("_parentId", map.get("PID"));
        }
        return new PageObject(list, new Long(list.size()));
    }

    @RequestMapping(value={"/queryOrgAndDeptListDefaultZero"})
    @ResponseBody
    public Object queryOrgAndDeptList() {
        List list = this.basOrgService.queryOrgAndDeptList("0");
        return ComboxUtils.buildComboxNodes(list);
    }

    @RequestMapping(value={"/saveOrg"})
    @ResponseBody
    public Object saveOrg(BasOrg basOrg) {
        if (this.basOrgService.hasRepeat(basOrg)) {
            return new JsonMsg(false, "\u673a\u6784\u540d\u79f0\u3001\u7f16\u7801\u3001\u7b80\u79f0\u548c\u52a9\u8bb0\u7801\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u5f55\u5165");
        }
        return this.basOrgService.saveOrg(basOrg);
    }

    @RequestMapping(value={"/deleOrg"}, method={RequestMethod.POST})
    @ResponseBody
    public Object deleOrg(String orgId) {
        BasOrg basOrg = this.basOrgService.findByOrgId(Long.parseLong(orgId));
        basOrg.setIsUse("N");
        return this.basOrgService.saveOrg(basOrg);
    }

    @RequestMapping(value={"/deleOrgs"}, method={RequestMethod.POST})
    @ResponseBody
    public Object deleOrgs(String orgId) {
        Long searchId = Long.parseLong(orgId);
        BasOrg basOrg = this.basOrgService.findByOrgId(searchId);
        basOrg.setIsUse("N");
        if (this.basOrgService.delOrgs(searchId)) {
            return this.basOrgService.saveOrg(basOrg);
        }
        return new JsonMsg(false, "\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/allFinanceOrg"})
    @ResponseBody
    @Deprecated
    public Object allFinanceOrg() {
        return this.basOrgService.allFinanceOrg();
    }

    @RequestMapping(value={"/getComboOrg"})
    @ResponseBody
    public Object getComboOrg(String type) {
        return this.basOrgService.getComboOrg(type);
    }

    @Deprecated
    @RequestMapping(value={"/getComboOrgByType"})
    @ResponseBody
    public Object getComboOrgByType(String type) {
        return this.basOrgService.getComboOrg(type);
    }

    @RequestMapping(value={"/getComboDeptForGroup"})
    @ResponseBody
    @Deprecated
    public Object getComboDeptForGroup() {
        return this.basOrgService.getComboDeptForGroup();
    }

    @RequestMapping(value={"/getComboDeptForLogin"})
    @ResponseBody
    public Object getComboDeptForLogin(HttpServletRequest request) {
        Long orgId = this.getLoginUser(request).getOrgid();
        return this.basOrgService.getComboDeptForLogin(orgId);
    }

    @RequestMapping(value={"/getNextDept"})
    @ResponseBody
    public Object getNextDept() {
        Long deptid = SysUtils.getLoginUser().getDeptid();
        return this.basOrgService.getNextDept(deptid);
    }

    @RequestMapping(value={"/getComboOrgNew"})
    @ResponseBody
    @Deprecated
    public Object getComboOrgNew(String type) {
        return this.basOrgService.getComboOrg(type);
    }

    @RequestMapping(value={"/getComboOrgTop"})
    @ResponseBody
    public Object getComboOrgTop(HttpServletRequest request, Long orgId) {
        if (orgId == null) {
            orgId = this.getLoginUser(request).getOrgid();
        }
        return this.basOrgService.getComboOrgTop(orgId);
    }

    @RequestMapping(value={"/getRetrieveCodeById"})
    @ResponseBody
    public Object getRetrieveCodeById(Long orgId) {
        JsonMsg msg = new JsonMsg();
        return msg;
    }

    @RequestMapping(value={"/findTaxTypeByOrgId"})
    @ResponseBody
    public Object findTaxTypeByOrgId(Long orgId) {
        JsonMsg msg = new JsonMsg();
        BasOrg entity = this.basOrgService.findTaxTypeByOrgId(orgId);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/getComboxListForApplyOrg"})
    @ResponseBody
    public List<ComboxNode> getComboxListForApplyOrg(Long orgId, String level) {
        JsonMsg msg = new JsonMsg();
        return this.basOrgService.getComboxListForApplyOrg(orgId, level);
    }

    @RequestMapping(value={"/querySubUnit"})
    @ResponseBody
    public Object querySubUnit(Long id, String excludeids, HttpServletRequest request, String detailId) {
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgDeptName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basOrgService.querySubUnit(id, excludeids);
    }

    @RequestMapping(value={"/getSubUnitAndSeptByOrg"})
    @ResponseBody
    public List<ComboxNode> getComboxListForApplyOrg(Long orgId, Boolean isdetail, String detailId) {
        if ("null".equals(isdetail) || isdetail == null) {
            isdetail = false;
        }
        JsonMsg msg = new JsonMsg();
        return this.basOrgService.getSubUnitAndSeptByOrg(orgId, isdetail);
    }

    @RequestMapping(value={"/getComboOrgSimple"})
    @ResponseBody
    public Object getComboOrgSimple() {
        return this.basOrgService.getComboOrgSimple();
    }

    @RequestMapping(value={"/queryOrgAndDeptTreeWb"})
    @ResponseBody
    public Object queryOrgAndDeptTreeWb(String id, HttpServletRequest request, String detailId, String orgId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgDeptName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basOrgService.queryOrgAndDeptTreeWb(id, orgId);
    }

    @RequestMapping(value={"/queryOrgAndDeptTreeByOwn"})
    @ResponseBody
    @Deprecated
    public Object queryOrgAndDeptTreeByOwn(String id, HttpServletRequest request, String detailId, String type, String orgId, @RequestParam(value="showCancel", defaultValue="N") String showCancel) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgDeptName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        if (StringUtil.isNotEmpty(orgId)) {
            return this.basOrgService.queryOrgAndDeptTree(id, orgId, type, showCancel);
        }
        return this.basOrgService.queryOrgAndDeptTree(id, this.getLoginUser(request).getOrgid() + "", type, showCancel);
    }

    @RequestMapping(value={"/getOrgTreeByDataPerm"})
    @ResponseBody
    public List<ComBoxTreeNode> getOrgTreeByDataPerm(String dataPerm) {
        return this.basOrgService.getOrgTreeByDataPerm(dataPerm);
    }

    @RequestMapping(value={"/queryOrgAndDeptTreeRoot"})
    @ResponseBody
    public Object queryOrgAndDeptTreeRoot(String detailId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            root.setId(detailId.toString());
            root.setText(this.basOrgService.getOrgDeptName(detailId));
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basOrgService.queryOrgAndDeptTreeRoot();
    }

    @PostMapping(value={"/findInsideOrgList"})
    @ResponseBody
    public JsonMsg findInsideOrgList() {
        List<Map<String, Object>> insideOrgList = this.basOrgService.findInsideOrgList();
        return new JsonMsg(true, "", insideOrgList);
    }

    @RequestMapping(value={"/queryOrgTreeByEscrow"})
    @ResponseBody
    public Object queryOrgTreeByEscrow(@RequestParam(value="pid", defaultValue="0") Long pid, String detailId, String type) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            String[] ids = detailId.split(",");
            String orgName = "";
            for (String id : ids) {
                BasOrg org = this.basOrgService.findByOrgId(Long.parseLong(id));
                if (org == null) continue;
                orgName = orgName + "," + org.getAbbr();
            }
            if (StringUtils.isNotBlank((String)orgName)) {
                orgName = orgName.substring(1);
            }
            root.setId(detailId.toString());
            root.setText(orgName);
            root.setChecked(true);
            list.add(root);
            return list;
        }
        List<ComBoxTreeNode> treelist = this.basOrgService.queryOrgTreeByEscrow(pid, type);
        return treelist;
    }

    @RequestMapping(value={"/getSubUnitAndSOrg"})
    @ResponseBody
    public List<ComboxCheckNode> getSubUnitAndSOrg(String checkValue) {
        return this.basOrgService.getSubUnitAndSOrg(checkValue);
    }

    @RequestMapping(value={"/queryThisUnitAndItsSubsidiaries"})
    @ResponseBody
    public List<ComBoxTreeNode> queryThisUnitAndItsSubsidiaries(String orgId, Boolean isTree) {
        return this.basOrgService.queryThisUnitAndItsSubsidiaries(orgId, isTree);
    }

    @RequestMapping(value={"/getOrgEmpNums"})
    @ResponseBody
    public Long getOrgEmpNums(Long orgId, String showCancel, boolean getAll) {
        if (orgId == null) {
            orgId = SysUtils.getLoginUser().getOrgid();
        }
        return this.basOrgService.getOrgEmpNums(orgId, showCancel, getAll);
    }

    @RequestMapping(value={"/getBasOrgCombotree"})
    @ResponseBody
    public List<ComBoxTreeNode> getBasOrgCombotree(GetBasOrgCombotreeReq combotreeReq) {
        return this.basOrgService.getBasOrgCombotree(combotreeReq);
    }
}

