/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.util.DateUtils;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasDemandApply;
import com.guochuang.imp.base.service.BasDemandApplyService;
import com.guochuang.imp.doc.entity.FormFileBean;
import com.guochuang.imp.pub.service.PubFlowRelateService;
import com.guochuang.imp.util.ReflectUtil;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basDemandApply"})
public class BasDemandApplyController
extends BaseController {
    @Autowired
    private BasDemandApplyService basDemandApplyService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private PubFlowRelateService pubflowrelateService;

    @PostMapping(value={"/pageAll"})
    @ResponseBody
    public PageObject pageAll(String search, Long flowDone, int page, int rows, String sort, String order) {
        return this.basDemandApplyService.pageAll(search, flowDone, page, rows, sort, order);
    }

    @PostMapping(value={"/saveBasDemandApply"})
    @ResponseBody
    public JsonMsg saveBasDemandApply(HttpServletRequest request, BasDemandApply entity, String formcode, FormFileBean formfile) throws GEPSBisException {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        this.basDemandApplyService.saveBasDemandApply(entity, formfile);
        if (entity.getProcessinstid() == null) {
            Long processinstid = this.flowUtilService.createAndStartProcess(this.getLoginUser(request).getAccountid(), formcode, entity.getId(), "", request.getParameter("app"));
            entity.setProcessinstid(processinstid);
        }
        msg.setO(entity);
        return msg;
    }

    @PostMapping(value={"/handleBasDemandApply"})
    @ResponseBody
    public JsonMsg handleBasDemandApply(HttpServletRequest request, Long id, String handleMan, String handleDate, FormFileBean formfile) throws GEPSBisException, ParseException {
        JsonMsg msg = new JsonMsg();
        BasDemandApply entity = this.basDemandApplyService.findBasDemandApply(id);
        entity.setHandleMan(handleMan);
        entity.setHandleDate(DateUtils.strToDate(handleDate, "yyyy-MM-dd"));
        entity.setHandleStatus("2");
        this.basDemandApplyService.saveBasDemandApply(entity);
        return msg;
    }

    @PostMapping(value={"/findBasDemandApply"})
    @ResponseBody
    public BasDemandApply findBasDemandApply(Long id) {
        BasDemandApply entity = this.basDemandApplyService.findBasDemandApply(id);
        return entity;
    }

    @PostMapping(value={"/delBasDemandApply"})
    @ResponseBody
    public JsonMsg delBasDemandApply(Long id) {
        this.basDemandApplyService.delBasDemandApply(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/basDemandApplyPrintTable"})
    public String basDemandApplyPrintTable(Long id, Model model) {
        BasDemandApply entity = this.basDemandApplyService.findBasDemandApply(id);
        Map<String, Object> ObjectMap = ReflectUtil.beanToMap(entity);
        String orgName = MemCache.getOrgName(entity.getOrgId());
        String deptName = MemCache.getDeptName(entity.getDeptId());
        String ApplyManName = MemCache.getEmpAccountName(entity.getApplyMan());
        String demandTypeText = MemCache.getDicText("DEMAND_TYPE", entity.getDemandType());
        ObjectMap.put("orgName", orgName);
        ObjectMap.put("deptName", deptName);
        ObjectMap.put("ApplyManName", ApplyManName);
        ObjectMap.put("demandTypeText", demandTypeText);
        if (id != null) {
            List<Map<String, Object>> pfrList = this.pubflowrelateService.findByRelateBizId(id, "BasDemandApply");
            model.addAttribute("pfrList", pfrList);
        } else {
            model.addAttribute("pfrList", (Object)Collections.EMPTY_LIST);
        }
        List<Map<String, Object>> adviceList = this.basDemandApplyService.findAllAdvice(id);
        HashMap<String, String> advices = new HashMap<String, String>();
        HashMap<String, String> sender = new HashMap<String, String>();
        HashMap<String, String> adviceTime = new HashMap<String, String>();
        for (Map<String, Object> map : adviceList) {
            advices.put(map.get("activitydefid") != null ? map.get("activitydefid").toString() : "", map.get("workmemory") != null ? map.get("workmemory").toString() : "");
            sender.put(map.get("activitydefid") != null ? map.get("activitydefid").toString() : "", map.get("accountName") != null ? map.get("accountName").toString() : "");
            adviceTime.put(map.get("activitydefid") != null ? map.get("activitydefid").toString() : "", map.get("endtime") != null ? map.get("endtime").toString() : "");
        }
        model.addAttribute("processdefName", adviceList.get(0).get("processdefname"));
        model.addAttribute("advices", advices);
        model.addAttribute("sender", sender);
        model.addAttribute("adviceTime", adviceTime);
        model.addAttribute("ObjectMap", ObjectMap);
        model.addAttribute("id", (Object)id);
        return "/base/basDemandApplyPrintTable";
    }
}

