/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util.fileupload;

import com.guochuang.imp.base.common.util.fileupload.UploadProgressListener;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class ProgessCommonsMultipartResolver
extends CommonsMultipartResolver {
    private HttpServletRequest request;

    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        ServletFileUpload upload = new ServletFileUpload(fileItemFactory);
        upload.setSizeMax(-1L);
        if (this.request != null) {
            HttpSession session = this.request.getSession();
            UploadProgressListener uploadProgressListener = new UploadProgressListener(session);
            upload.setProgressListener((ProgressListener)uploadProgressListener);
        }
        return upload;
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        this.request = request;
        return super.resolveMultipart(request);
    }

    public CommonsFileUploadSupport.MultipartParsingResult parseRequest(HttpServletRequest request) throws MultipartException {
        HttpSession session = request.getSession();
        String encoding = "utf-8";
        FileUpload fileUpload = this.prepareFileUpload(encoding);
        UploadProgressListener uploadProgressListener = new UploadProgressListener(session);
        fileUpload.setProgressListener((ProgressListener)uploadProgressListener);
        try {
            List fileItems = ((ServletFileUpload)fileUpload).parseRequest(request);
            return this.parseFileItems(fileItems, encoding);
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getSizeMax(), (Throwable)ex);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Could not parse multipart servlet request", (Throwable)ex);
        }
    }
}

