/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util.exceltools;

import com.guochuang.imp.base.common.util.exceltools.TableColumn;
import java.util.LinkedList;
import java.util.List;

public class TableHeaderMetaData {
    private LinkedList<TableColumn> columns = new LinkedList();
    private LinkedList<TableColumn> leafs = new LinkedList();
    private String common;
    public int maxlevel = 0;

    public void addColumn(TableColumn col) {
        this.setLevel(col, 1);
        this.columns.add(col);
        this.addLeafColumn(col);
    }

    public void refresh() {
        this.maxlevel = 1;
        for (TableColumn col : this.columns) {
            if (!col.isVisible()) continue;
            col.level = 1;
            int level = this.refreshChildren(col);
            if (level <= this.maxlevel) continue;
            this.maxlevel = level;
        }
    }

    private int refreshChildren(TableColumn parent) {
        if (!parent.children.isEmpty()) {
            int max = parent.level;
            for (TableColumn col : parent.children) {
                if (!col.isVisible()) continue;
                col.parent = parent;
                col.level = parent.level + 1;
                int level = this.refreshChildren(col);
                if (level <= max) continue;
                max = level;
            }
            return max;
        }
        return parent.level;
    }

    private void setLevel(TableColumn col, int level) {
        col.level = level;
        if (col.isVisible() && level > this.maxlevel) {
            this.maxlevel = level;
        }
    }

    private void addLeafColumn(TableColumn col) {
        if (col.parent != null) {
            this.setLevel(col, col.parent.level + 1);
        }
        if (col.isComplex()) {
            for (TableColumn c : col.getChildren()) {
                this.addLeafColumn(c);
            }
        } else {
            this.leafs.add(col);
        }
    }

    public List<TableColumn> getColumns() {
        return this.leafs;
    }

    public List<TableColumn> getOriginColumns() {
        LinkedList<TableColumn> ret = new LinkedList<TableColumn>();
        for (TableColumn c : this.columns) {
            if (!c.isVisible()) continue;
            ret.add(c);
        }
        return ret;
    }

    public TableColumn getColumnAt(int index) {
        return this.leafs.get(index);
    }

    public int getColumnCount() {
        return this.leafs.size();
    }

    public String getCommon() {
        return this.common;
    }

    public void setCommon(String common) {
        this.common = common;
    }
}

