/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util.exceltools;

import com.guochuang.imp.base.common.util.exceltools.ExcelUtils;
import com.guochuang.imp.base.common.util.exceltools.TableColumn;
import com.guochuang.imp.base.common.util.exceltools.TableData;
import com.guochuang.imp.base.common.util.exceltools.TableDataCell;
import com.guochuang.imp.base.common.util.exceltools.TableDataRow;
import com.guochuang.imp.base.common.util.exceltools.TableHeaderMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.core.io.ClassPathResource;

public class JsGridReportBase {
    private static final Logger LOGGER = Logger.getLogger(JsGridReportBase.class);
    private HttpServletResponse response;
    private HttpSession session;
    private ServletOutputStream out;
    public static final int EXCEL_MAX_CNT = 100000;
    public static final int SHEET_MAX_CNT = 20000;

    public JsGridReportBase() {
    }

    public JsGridReportBase(HttpServletRequest request, HttpServletResponse response) {
        this.response = response;
        this.session = request.getSession();
        this.init(this.session);
    }

    private void init(HttpSession session) {
        try {
            this.out = this.response.getOutputStream();
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u6587\u4ef6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
        }
    }

    public void outDataToBrowser(TableData tableData) {
        StringBuilder outData = new StringBuilder();
        outData.append("{pageInfo: {totalRowNum: " + tableData.getTotalRows() + "},");
        outData.append("data: [");
        boolean isFirst = true;
        TableHeaderMetaData headerMetaData = tableData.getTableHeader();
        List<TableDataRow> dataRows = tableData.getRows();
        try {
            for (TableDataRow dataRow : dataRows) {
                int index;
                int i;
                List<TableDataCell> dataCells = dataRow.getCells();
                int size = dataCells.size();
                if (!isFirst) {
                    outData.append(",{");
                    for (i = 0; i < size; ++i) {
                        outData.append(headerMetaData.getColumnAt(i).getId() + ": '" + dataCells.get(i).getValue() + "',");
                    }
                    index = outData.lastIndexOf(",");
                    outData.deleteCharAt(index);
                    outData.append("}");
                    continue;
                }
                outData.append("{");
                for (i = 0; i < size; ++i) {
                    outData.append(headerMetaData.getColumnAt(i).getId() + ": '" + dataCells.get(i).getValue() + "',");
                }
                index = outData.lastIndexOf(",");
                outData.deleteCharAt(index);
                outData.append("}");
                isFirst = false;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u6570\u636e\u8f93\u51fa\u9519\u8bef!", (Throwable)e);
        }
        outData.append("]");
        outData.append("}");
        try {
            this.out.print(outData.toString());
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u6587\u4ef6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
        }
    }

    private void stopGrouping(HSSFSheet sheet, Map<Integer, String> word, Map<Integer, Integer> counter, int i, int size, int rownum, HSSFCellStyle style) {
        String w = word.get(i);
        if (w != null) {
            int len = counter.get(i);
            CellRangeAddress address = new CellRangeAddress(rownum - len, rownum - 1, i, i);
            sheet.addMergedRegion(address);
            this.fillMergedRegion(sheet, address, style);
            word.remove(i);
            counter.remove(i);
        }
        if (i + 1 < size) {
            this.stopGrouping(sheet, word, counter, i + 1, size, rownum, style);
        }
    }

    private void generateColumn(HSSFSheet sheet, TableColumn tc, int maxlevel, int rownum, int colnum, HSSFCellStyle headerstyle) {
        HSSFRow row = sheet.getRow(rownum);
        if (row == null) {
            row = sheet.createRow(rownum);
            row.setHeightInPoints(30.0f);
        }
        HSSFCell cell = row.createCell(colnum);
        cell.setCellValue(tc.getDisplay());
        if (headerstyle != null) {
            cell.setCellStyle(headerstyle);
        }
        if (tc.isComplex()) {
            if (tc.getLength() > 1) {
                CellRangeAddress address = new CellRangeAddress(rownum, rownum, colnum, colnum + tc.getLength() - 1);
                sheet.addMergedRegion(address);
                this.fillMergedRegion(sheet, address, headerstyle);
            }
            int cn = colnum;
            for (int i = 0; i < tc.getChildren().size(); ++i) {
                if (i != 0) {
                    cn += tc.getChildren().get(i - 1).getLength();
                }
                this.generateColumn(sheet, tc.getChildren().get(i), maxlevel, rownum + 1, cn, headerstyle);
            }
        } else {
            try {
                CellRangeAddress address = new CellRangeAddress(rownum, rownum + maxlevel - tc.level, colnum, colnum);
                sheet.addMergedRegion(address);
                this.fillMergedRegion(sheet, address, headerstyle);
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug((Object)"\u5bfc\u51fa\u65f6\u8868\u5934\u5355\u5143\u683c\u9519\u8bef(POI 3.14 \u7248\u672c\u9020\u6210)", (Throwable)e);
            }
        }
        sheet.autoSizeColumn(colnum, true);
    }

    private void fillMergedRegion(HSSFSheet sheet, CellRangeAddress address, HSSFCellStyle style) {
        for (int i = address.getFirstRow(); i <= address.getLastRow(); ++i) {
            HSSFRow row = sheet.getRow(i);
            if (row == null) {
                row = sheet.createRow(i);
                row.setHeightInPoints(30.0f);
            }
            for (int j = address.getFirstColumn(); j <= address.getLastColumn(); ++j) {
                HSSFCell cell = row.getCell(j);
                if (cell != null) continue;
                cell = row.createCell(j);
                if (style == null) continue;
                cell.setCellStyle(style);
            }
        }
    }

    public HSSFWorkbook writeSheet(HSSFWorkbook wb, String title, Map<String, HSSFCellStyle> styles, String creator, TableData tableData, Boolean showHeadTitle, String headTitle) {
        TableHeaderMetaData headerMetaData = tableData.getTableHeader();
        HSSFSheet sheet = wb.createSheet(title);
        sheet.setDisplayGridlines(true);
        int rownum = 0;
        HSSFRow row = null;
        if (showHeadTitle.booleanValue()) {
            int fieldLength = headerMetaData.getColumnCount();
            sheet.addMergedRegion(new CellRangeAddress(0, 1, 0, fieldLength - 1));
            row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue((RichTextString)new HSSFRichTextString(headTitle));
            HSSFCellStyle style = styles.get("TITLE");
            if (style != null) {
                cell.setCellStyle(style);
            }
            rownum = 2;
        }
        HSSFCellStyle headerstyle = styles.get("TABLE_HEADER");
        int colnum = 0;
        for (int i = 0; i < headerMetaData.getOriginColumns().size(); ++i) {
            TableColumn tc = headerMetaData.getOriginColumns().get(i);
            if (i != 0) {
                colnum += headerMetaData.getOriginColumns().get(i - 1).getLength();
            }
            this.generateColumn(sheet, tc, headerMetaData.maxlevel, rownum, colnum, headerstyle);
        }
        sheet.createFreezePane(0, rownum += headerMetaData.maxlevel, 0, rownum);
        List<TableDataRow> dataRows = tableData.getRows();
        HashMap<Integer, Integer> counter = new HashMap<Integer, Integer>();
        HashMap<Integer, String> word = new HashMap<Integer, String>();
        int index = 0;
        for (TableDataRow dataRow : dataRows) {
            row = sheet.createRow(rownum);
            row.setHeightInPoints(30.0f);
            List<TableDataCell> dataCells = dataRow.getCells();
            int size = headerMetaData.getColumns().size();
            index = -1;
            for (int i = 0; i < size; ++i) {
                TableColumn tc = headerMetaData.getColumns().get(i);
                if (!tc.isVisible()) continue;
                this.createCell(row, tc, dataCells, i, ++index, styles);
            }
            ++rownum;
        }
        this.stopGrouping(sheet, word, counter, 0, index, rownum, styles.get("STRING"));
        for (int c = 0; c < headerMetaData.getColumns().size(); ++c) {
            if (headerMetaData.getColumns().get(c).getWidth() > 0) {
                sheet.setColumnWidth(c, headerMetaData.getColumns().get(c).getWidth() * 256);
                continue;
            }
            sheet.autoSizeColumn((int)((short)c));
            String t = headerMetaData.getColumns().get(c).getDisplay();
            if (sheet.getColumnWidth(c) < t.length() * 256 * 3) {
                sheet.setColumnWidth(c, t.length() * 256 * 3);
            }
            if (sheet.getColumnWidth(c) <= 25600) continue;
            sheet.setColumnWidth(c, 25600);
        }
        sheet.setGridsPrinted(true);
        return wb;
    }

    public HSSFWorkbook writeSheet(HSSFWorkbook wb, Map<String, HSSFCellStyle> styles, String creator, List<TableData> tableDataLst) {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206");
        String createTime = formater.format(new Date());
        int cnt = 1;
        for (TableData tableData : tableDataLst) {
            String sheetTitle = tableData.getSheetTitle();
            sheetTitle = sheetTitle == null || "".equals(sheetTitle) ? "sheet" + cnt : sheetTitle;
            ++cnt;
            TableHeaderMetaData headerMetaData = tableData.getTableHeader();
            HSSFSheet sheet = wb.createSheet(sheetTitle);
            sheet.setDisplayGridlines(false);
            wb.cloneSheet(0);
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            int rownum = 0;
            cell.setCellValue((RichTextString)new HSSFRichTextString(sheetTitle));
            HSSFCellStyle style = styles.get("TITLE");
            if (style != null) {
                cell.setCellStyle(style);
            }
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headerMetaData.getColumnCount() - 1));
            row = sheet.createRow(1);
            cell = row.createCell(0);
            cell.setCellValue((RichTextString)new HSSFRichTextString("\u521b\u5efa\u4eba:"));
            style = styles.get("SUB_TITLE");
            if (style != null) {
                cell.setCellStyle(style);
            }
            cell = row.createCell(1);
            cell.setCellValue((RichTextString)new HSSFRichTextString(creator));
            style = styles.get("SUB_TITLE2");
            if (style != null) {
                cell.setCellStyle(style);
            }
            cell = row.createCell(2);
            cell.setCellValue((RichTextString)new HSSFRichTextString("\u521b\u5efa\u65f6\u95f4:"));
            style = styles.get("SUB_TITLE");
            if (style != null) {
                cell.setCellStyle(style);
            }
            cell = row.createCell(3);
            style = styles.get("SUB_TITLE2");
            cell.setCellValue((RichTextString)new HSSFRichTextString(createTime));
            if (style != null) {
                cell.setCellStyle(style);
            }
            rownum = 3;
            HSSFCellStyle headerstyle = styles.get("TABLE_HEADER");
            int colnum = 0;
            for (int i = 0; i < headerMetaData.getOriginColumns().size(); ++i) {
                TableColumn tc = headerMetaData.getOriginColumns().get(i);
                if (i != 0) {
                    colnum += headerMetaData.getOriginColumns().get(i - 1).getLength();
                }
                this.generateColumn(sheet, tc, headerMetaData.maxlevel, rownum, colnum, headerstyle);
            }
            rownum += headerMetaData.maxlevel;
            List<TableDataRow> dataRows = tableData.getRows();
            int index = 0;
            for (TableDataRow dataRow : dataRows) {
                row = sheet.createRow(rownum);
                List<TableDataCell> dataCells = dataRow.getCells();
                int size = headerMetaData.getColumns().size();
                index = -1;
                for (int i = 0; i < size; ++i) {
                    TableColumn tc = headerMetaData.getColumns().get(i);
                    if (!tc.isVisible()) continue;
                    this.createCell(row, tc, dataCells, i, ++index, styles);
                }
                ++rownum;
            }
            for (int c = 0; c < headerMetaData.getColumns().size(); ++c) {
                sheet.autoSizeColumn((int)((short)c));
                String t = headerMetaData.getColumns().get(c).getDisplay();
                if (sheet.getColumnWidth(c) >= t.length() * 256 * 3) continue;
                sheet.setColumnWidth(c, t.length() * 256 * 3);
            }
            sheet.setGridsPrinted(true);
        }
        return wb;
    }

    public void exportToExcel(String title, String creator, TableData tableData) {
        this.exportToExcel(title, creator, tableData, (Boolean)true, title);
    }

    public void exportToExcel(String title, String creator, TableData tableData, Boolean showHeadTitle, String headTitle) {
        HSSFWorkbook wb = new HSSFWorkbook();
        Map<String, HSSFCellStyle> styles = this.initStyles(wb);
        wb = this.writeSheet(wb, title, styles, creator, tableData, showHeadTitle, headTitle);
        String sFileName = title + ".xls";
        try {
            this.response.setHeader("Content-Disposition", "attachment;filename=".concat(String.valueOf(URLEncoder.encode(sFileName, "UTF-8"))));
        }
        catch (UnsupportedEncodingException e1) {
            LOGGER.error((Object)"\u6587\u4ef6\u51fa\u73b0\u9519\u8bef!", (Throwable)e1);
        }
        this.response.setHeader("Connection", "close");
        this.response.setHeader("Content-Type", "application/vnd.ms-excel");
        try {
            wb.write((OutputStream)this.response.getOutputStream());
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u6587\u4ef6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
        }
    }

    public void exportToExcelMulti(String bigTitle, String titles, String creator, List<TableData> tdList) {
        this.exportToExcelMulti(bigTitle, titles, creator, tdList, true, titles);
    }

    public void exportToExcelMulti(String bigTitle, String titles, String creator, List<TableData> tdList, Boolean showHeadTitle, String headTitles) {
        String[] titlesData = titles.split(",");
        String[] headtitlesData = headTitles.split(",");
        HSSFWorkbook wb = new HSSFWorkbook();
        Map<String, HSSFCellStyle> styles = this.initStyles(wb);
        for (int i = 0; i < tdList.size(); ++i) {
            TableData tableData = tdList.get(i);
            this.writeSheet(wb, titlesData[i], styles, creator, tableData, showHeadTitle, headtitlesData[i]);
        }
        String sFileName = bigTitle + ".xls";
        try {
            this.response.setHeader("Content-Disposition", "attachment;filename=".concat(String.valueOf(URLEncoder.encode(sFileName, "UTF-8"))));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"\u6587\u4ef6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
        }
        this.response.setHeader("Connection", "close");
        this.response.setHeader("Content-Type", "application/vnd.ms-excel");
        try {
            wb.write((OutputStream)this.response.getOutputStream());
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u6587\u4ef6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
        }
    }

    public void exportToExcel(String title, String creator, List<TableData> tableDataLst) {
        this.exportToExcel(title, creator, tableDataLst, (Boolean)true, title);
    }

    public void exportToExcel(String title, String creator, List<TableData> tableDataLst, Boolean showHeadTitle, String headTitle) {
        HSSFWorkbook wb = new HSSFWorkbook();
        Map<String, HSSFCellStyle> styles = this.initStyles(wb);
        int i = 1;
        for (TableData tableData : tableDataLst) {
            String sheetTitle = tableData.getSheetTitle();
            sheetTitle = sheetTitle == null || "".equals(sheetTitle) ? "sheet" + i : sheetTitle;
            wb = this.writeSheet(wb, tableData.getSheetTitle(), styles, creator, tableData, showHeadTitle, headTitle);
            ++i;
        }
        String sFileName = title + ".xls";
        try {
            this.response.setHeader("Content-Disposition", "attachment;filename=".concat(String.valueOf(URLEncoder.encode(sFileName, "UTF-8"))));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"\u6587\u4ef6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
        }
        this.response.setHeader("Connection", "close");
        this.response.setHeader("Content-Type", "application/vnd.ms-excel");
        try {
            wb.write((OutputStream)this.response.getOutputStream());
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u6587\u4ef6\u51fa\u73b0\u9519\u8bef!", (Throwable)e);
        }
    }

    private void createCell(HSSFRow row, TableColumn tc, List<TableDataCell> data, int i, int index, Map<String, HSSFCellStyle> styles) {
        TableDataCell dc = data.get(i);
        HSSFCell cell = row.createCell(index);
        switch (dc.getColumnType()) {
            case 3: {
                cell.setCellValue((double)dc.getIntValue());
                HSSFCellStyle style = styles.get("INT");
                if (row.getRowNum() % 2 != 0) {
                    style = styles.get("INT_C");
                }
                if (style == null) break;
                cell.setCellStyle(style);
                break;
            }
            case 1: {
                cell.setCellValue(dc.getDoubleValue());
                HSSFCellStyle style = styles.get("D2");
                if (row.getRowNum() % 2 != 0) {
                    style = styles.get("D2_C");
                }
                if (style == null) break;
                cell.setCellStyle(style);
                break;
            }
            case 2: {
                cell.setCellValue(dc.getDoubleValue());
                HSSFCellStyle style = styles.get("D3");
                if (row.getRowNum() % 2 != 0) {
                    style = styles.get("D3_C");
                }
                if (style == null) break;
                cell.setCellStyle(style);
                break;
            }
            case 24: {
                cell.setCellValue(dc.getDoubleValue());
                HSSFCellStyle style = styles.get("D4_C");
                if (style == null) break;
                cell.setCellStyle(style);
                break;
            }
            case 25: {
                cell.setCellValue(dc.getDoubleValue());
                HSSFCellStyle style = styles.get("D5_C");
                if (style == null) break;
                cell.setCellStyle(style);
                break;
            }
            case 26: {
                cell.setCellValue(dc.getDoubleValue());
                HSSFCellStyle style = styles.get("D6_C");
                if (style == null) break;
                cell.setCellStyle(style);
                break;
            }
            case 10: {
                cell.setCellValue(dc.getValue());
                HSSFCellStyle style = styles.get("RED_BG");
                if (style == null) break;
                cell.setCellStyle(style);
                break;
            }
            case 11: {
                cell.setCellValue(dc.getValue());
                HSSFCellStyle style = styles.get("YELLOW_BG");
                if (style == null) break;
                cell.setCellStyle(style);
                break;
            }
            case 12: {
                cell.setCellValue(dc.getValue());
                HSSFCellStyle style = styles.get("GREEN_BG");
                if (style == null) break;
                cell.setCellStyle(style);
                break;
            }
            default: {
                if ("&nbsp;".equalsIgnoreCase(dc.getValue())) {
                    cell.setCellValue("");
                } else {
                    cell.setCellValue(dc.getValue());
                }
                HSSFCellStyle style = styles.get("STRING");
                if (row.getRowNum() % 2 != 0) {
                    style = styles.get("STRING_C");
                }
                if (style == null) break;
                cell.setCellStyle(style);
            }
        }
    }

    public Map<String, HSSFCellStyle> initStyles(HSSFWorkbook wb) {
        HashMap<String, HSSFCellStyle> ret = new HashMap<String, HSSFCellStyle>();
        try {
            ClassPathResource res = new ClassPathResource("template/excel.xls");
            InputStream is = res.getInputStream();
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook src = new HSSFWorkbook(fs);
            HSSFSheet sheet = src.getSheetAt(0);
            this.buildStyle(wb, src, sheet, 0, ret, "TITLE");
            this.buildStyle(wb, src, sheet, 1, ret, "SUB_TITLE");
            this.buildStyle(wb, src, sheet, 2, ret, "SUB_TITLE2");
            this.buildStyle(wb, src, sheet, 4, ret, "TABLE_HEADER");
            this.buildStyle(wb, src, sheet, 5, ret, "STRING");
            this.buildStyle(wb, src, sheet, 6, ret, "INT");
            this.buildStyle(wb, src, sheet, 7, ret, "D2");
            this.buildStyle(wb, src, sheet, 8, ret, "D3");
            this.buildStyle(wb, src, sheet, 10, ret, "STRING_C");
            this.buildStyle(wb, src, sheet, 11, ret, "INT_C");
            this.buildStyle(wb, src, sheet, 12, ret, "D2_C");
            this.buildStyle(wb, src, sheet, 13, ret, "D3_C");
            this.buildStyle(wb, src, sheet, 14, ret, "D4_C");
            this.buildStyle(wb, src, sheet, 15, ret, "D5_C");
            this.buildStyle(wb, src, sheet, 16, ret, "D6_C");
            this.buildStyle(wb, src, sheet, 17, ret, "RED_BG");
            this.buildStyle(wb, src, sheet, 18, ret, "YELLOW_BG");
            this.buildStyle(wb, src, sheet, 19, ret, "GREEN_BG");
            this.buildStyle(wb, src, sheet, 22, ret, "red*");
            this.buildStyle(wb, src, sheet, 23, ret, "yellow*");
            this.buildStyle(wb, src, sheet, 24, ret, "blue*");
            this.buildStyle(wb, src, sheet, 25, ret, "green*");
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u521d\u59cb\u5316\u6837\u5f0f\u5931\u8d25!", (Throwable)e);
        }
        return ret;
    }

    private void buildStyle(HSSFWorkbook wb, HSSFWorkbook src, HSSFSheet sheet, int index, Map<String, HSSFCellStyle> ret, String key) {
        HSSFRow row = sheet.getRow(index);
        HSSFCell cell = row.getCell(1);
        HSSFCellStyle nstyle = wb.createCellStyle();
        ExcelUtils.copyCellStyle(wb, nstyle, src, cell.getCellStyle());
        nstyle.setWrapText(true);
        ret.put(key, nstyle);
    }

    protected String getUTF8String(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new String(string.getBytes("ISO8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3aUTF-8\u7f16\u7801\u5931\u8d25!", (Throwable)e);
            return string;
        }
    }

    protected String getGBKString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new String(string.getBytes("ISO8859-1"), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3aGBK\u7f16\u7801\u5931\u8d25!", (Throwable)e);
            return string;
        }
    }

    public String fieldRender(String value) {
        if (value == null) {
            return "&nbsp;";
        }
        return value;
    }
}

