/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

public class LunarCalendar {
    public static final int MIN_YEAR = 1900;
    public static final int MAX_YEAR = 2099;
    private static final int[] DAYS_BEFORE_MONTH = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] LUNAR_INFO = new int[]{8697535, 306771, 677704, 5580477, 861776, 890180, 4631225, 354893, 634178, 2404022, 306762, 6966718, 675154, 861510, 6116026, 742478, 879171, 2714935, 613195, 7642049, 300884, 674632, 5973436, 435536, 447557, 4905656, 177741, 612162, 2398135, 300874, 6703934, 870993, 959814, 5690554, 372046, 177732, 3749688, 601675, 8165055, 824659, 870984, 7185723, 742735, 354885, 4894137, 154957, 601410, 2921910, 693578, 8080061, 445009, 742726, 0x555ABB, 318030, 678723, 3484600, 338764, 9082175, 955730, 436808, 7001404, 701775, 308805, 4871993, 677709, 337474, 4100917, 890185, 7711422, 354897, 617798, 5549755, 306511, 675139, 5056183, 861515, 9261759, 742482, 748103, 6909244, 613200, 301893, 4869049, 674637, 11216322, 435540, 447561, 7002685, 702033, 612166, 5543867, 300879, 412484, 3581239, 959818, 8827583, 371795, 702023, 5846716, 601680, 824901, 5065400, 870988, 894273, 2468534, 354889, 8039869, 154962, 601415, 6067642, 693582, 739907, 4937015, 709962, 9788095, 309843, 678728, 6630332, 338768, 693061, 4672185, 436812, 709953, 2415286, 308810, 6969149, 675409, 861766, 6198074, 873293, 371267, 3585335, 617803, 11841215, 306515, 675144, 7153084, 861519, 873028, 6138424, 744012, 355649, 2403766, 301898, 8014782, 674641, 697670, 5984954, 447054, 711234, 3496759, 603979, 8689601, 300883, 412488, 6726972, 959823, 436804, 4896312, 699980, 601666, 3970869, 824905, 8211133, 870993, 894277, 0x55AABA, 354894, 683331, 4533943, 339275, 9082303, 693587, 739911, 7034171, 709967, 350789, 4873528, 678732, 338754, 3838902, 430921, 7809469, 436817, 709958, 5561018, 308814, 677699, 4532024, 861770, 9343806, 873042, 895559, 6731067, 355663, 306757, 4869817, 675148, 857409, 2986677};

    public static final int[] lunarToSolar(int year, int month, int monthDay, boolean isLeapMonth) {
        int i;
        if (year < 1900 || year > 2099 || month < 1 || month > 12 || monthDay < 1 || monthDay > 30) {
            throw new IllegalArgumentException("Illegal lunar date, must be like that:\n\tyear : 1900~2099\n\tmonth : 1~12\n\tday : 1~30");
        }
        int dayOffset = (LUNAR_INFO[year - 1900] & 0x1F) - 1;
        if ((LUNAR_INFO[year - 1900] & 0x60) >> 5 == 2) {
            dayOffset += 31;
        }
        for (i = 1; i < month; ++i) {
            if ((LUNAR_INFO[year - 1900] & 524288 >> i - 1) == 0) {
                dayOffset += 29;
                continue;
            }
            dayOffset += 30;
        }
        dayOffset += monthDay;
        int leapMonth = (LUNAR_INFO[year - 1900] & 0xF00000) >> 20;
        if (leapMonth != 0 && (month > leapMonth || month == leapMonth && isLeapMonth)) {
            dayOffset = (LUNAR_INFO[year - 1900] & 524288 >> month - 1) == 0 ? (dayOffset += 29) : (dayOffset += 30);
        }
        if (dayOffset > 366 || year % 4 != 0 && dayOffset > 365) {
            dayOffset = ++year % 4 == 1 ? (dayOffset -= 366) : (dayOffset -= 365);
        }
        int[] solarInfo = new int[3];
        for (i = 1; i < 13; ++i) {
            int iPos = DAYS_BEFORE_MONTH[i];
            if (year % 4 == 0 && i > 2) {
                ++iPos;
            }
            if (year % 4 == 0 && i == 2 && iPos + 1 == dayOffset) {
                solarInfo[1] = i;
                solarInfo[2] = dayOffset - 31;
                break;
            }
            if (iPos < dayOffset) continue;
            solarInfo[1] = i;
            iPos = DAYS_BEFORE_MONTH[i - 1];
            if (year % 4 == 0 && i > 2) {
                ++iPos;
            }
            if (dayOffset > iPos) {
                solarInfo[2] = dayOffset - iPos;
                break;
            }
            if (dayOffset == iPos) {
                if (year % 4 == 0 && i == 2) {
                    solarInfo[2] = DAYS_BEFORE_MONTH[i] - DAYS_BEFORE_MONTH[i - 1] + 1;
                    break;
                }
                solarInfo[2] = DAYS_BEFORE_MONTH[i] - DAYS_BEFORE_MONTH[i - 1];
                break;
            }
            solarInfo[2] = dayOffset;
            break;
        }
        solarInfo[0] = year;
        return solarInfo;
    }

    public static final int[] solarToLunar(int year, int month, int monthDay) {
        int iMonth;
        int iYear;
        int[] lunarDate = new int[4];
        Date baseDate = new GregorianCalendar(1900, 0, 31).getTime();
        Date objDate = new GregorianCalendar(year, month - 1, monthDay).getTime();
        int offset = (int)((objDate.getTime() - baseDate.getTime()) / 86400000L);
        int daysOfYear = 0;
        for (iYear = 1900; iYear <= 2099 && offset > 0; offset -= daysOfYear, ++iYear) {
            daysOfYear = LunarCalendar.daysInLunarYear(iYear);
        }
        if (offset < 0) {
            offset += daysOfYear;
        }
        lunarDate[0] = --iYear;
        int leapMonth = LunarCalendar.leapMonth(iYear);
        boolean isLeap = false;
        int daysOfMonth = 0;
        for (iMonth = 1; iMonth <= 13 && offset > 0; offset -= daysOfMonth, ++iMonth) {
            daysOfMonth = LunarCalendar.daysInLunarMonth(iYear, iMonth);
        }
        if (leapMonth != 0 && iMonth > leapMonth && --iMonth == leapMonth) {
            isLeap = true;
        }
        if (offset < 0) {
            offset += daysOfMonth;
        }
        lunarDate[1] = --iMonth;
        lunarDate[2] = offset + 1;
        lunarDate[3] = isLeap ? 1 : 0;
        return lunarDate;
    }

    public static final int daysInMonth(int year, int month) {
        return LunarCalendar.daysInMonth(year, month, false);
    }

    public static final int daysInMonth(int year, int month, boolean leap) {
        int leapMonth = LunarCalendar.leapMonth(year);
        int offset = 0;
        if (leapMonth != 0 && month > leapMonth) {
            offset = 1;
        }
        if (!leap) {
            return LunarCalendar.daysInLunarMonth(year, month + offset);
        }
        if (leapMonth != 0 && leapMonth == month) {
            return LunarCalendar.daysInLunarMonth(year, month + 1);
        }
        return 0;
    }

    private static int daysInLunarYear(int year) {
        int sum = 348;
        if (LunarCalendar.leapMonth(year) != 0) {
            sum = 377;
        }
        int monthInfo = LUNAR_INFO[year - 1900] & 0xFFF80;
        for (int i = 524288; i > 7; i >>= 1) {
            if ((monthInfo & i) == 0) continue;
            ++sum;
        }
        return sum;
    }

    private static int daysInLunarMonth(int year, int month) {
        if ((LUNAR_INFO[year - 1900] & 0x100000 >> month) == 0) {
            return 29;
        }
        return 30;
    }

    private static int leapMonth(int year) {
        return (LUNAR_INFO[year - 1900] & 0xF00000) >> 20;
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(LunarCalendar.solarToLunar(2020, 4, 4)));
        System.out.println(Arrays.toString(LunarCalendar.lunarToSolar(2020, 4, 4, false)));
    }
}

