/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.doc.entity.DocFileVersion;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpClientUtil {
    public static Logger loger = Logger.getLogger(HttpClientUtil.class);
    public static final String DEFAULT_CONTENT_ENCODING = "UTF-8";
    public static final int cache = 10240;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer fileUpload(String url, String filePath) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        StringBuffer result = new StringBuffer();
        try {
            HttpPost httppost = new HttpPost(url);
            File file = new File(filePath);
            FileBody bin = new FileBody(file, ContentType.DEFAULT_BINARY, URLEncoder.encode(file.getName(), "utf-8"));
            StringBody comment = new StringBody("A binary file of some kind", ContentType.MULTIPART_FORM_DATA);
            HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("files", (ContentBody)bin).addPart("comment", (ContentBody)comment).setCharset(StandardCharsets.UTF_8).build();
            httppost.setEntity(reqEntity);
            loger.info((Object)("executing request: " + httppost.getRequestLine()));
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                loger.info((Object)("response status: " + response.getStatusLine()));
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    InputStreamReader reader = new InputStreamReader(resEntity.getContent(), DEFAULT_CONTENT_ENCODING);
                    char[] buff = new char[1024];
                    int length = 0;
                    while ((length = reader.read(buff)) != -1) {
                        result.append(buff, 0, length);
                    }
                }
                EntityUtils.consume((HttpEntity)resEntity);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer fileUpload(String url, File file) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        StringBuffer result = new StringBuffer();
        try {
            HttpPost httppost = new HttpPost(url);
            FileBody bin = new FileBody(file);
            StringBody comment = new StringBody("A binary file of some kind", ContentType.MULTIPART_FORM_DATA);
            HttpEntity reqEntity = MultipartEntityBuilder.create().addPart("files", (ContentBody)bin).addPart("comment", (ContentBody)comment).build();
            httppost.setEntity(reqEntity);
            loger.info((Object)("executing request: " + httppost.getRequestLine()));
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                loger.info((Object)("response status: " + response.getStatusLine()));
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    InputStreamReader reader = new InputStreamReader(resEntity.getContent(), DEFAULT_CONTENT_ENCODING);
                    char[] buff = new char[1024];
                    int length = 0;
                    while ((length = reader.read(buff)) != -1) {
                        result.append(buff, 0, length);
                    }
                }
                EntityUtils.consume((HttpEntity)resEntity);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String urlParam, String filepath, boolean needCreateFolder) {
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        try {
            int numRead;
            URL url = new URL(urlParam);
            File file = new File(filepath);
            if (needCreateFolder) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new BufferedOutputStream(Files.newOutputStream(Paths.get(filepath, new String[0]), new OpenOption[0]));
            conn = url.openConnection();
            in = conn.getInputStream();
            byte[] buffer = new byte[1024];
            while ((numRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, numRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static JSONObject synFileWithTwoSystem(HttpServletRequest request, DocFileVersion docFileVersion, String synUrl, String param) {
        JSONObject jsonObject = new JSONObject();
        String requestUrl = "http://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        String requestPath = "/file/download";
        String fileName = "tempFileFolder\\" + docFileVersion.getOriginalName();
        HttpClientUtil.downloadFile(requestUrl + requestPath + "?versionid=" + docFileVersion.getVersionId(), fileName, true);
        StringBuffer sb = HttpClientUtil.fileUpload(synUrl + param, fileName);
        try {
            jsonObject = JSONObject.parseObject((String)sb.toString());
        }
        catch (Exception e) {
            loger.error((Object)"\u4e0a\u4f20\u5931\u8d25");
        }
        jsonObject.put("fileNames", (Object)fileName);
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        return jsonObject;
    }

    public static String getFilePath(HttpResponse response) {
        return HttpClientUtil.getFileName(response);
    }

    public static String getFileName(HttpResponse response) {
        NameValuePair param;
        HeaderElement[] values;
        Header contentHeader = response.getFirstHeader("Content-Disposition");
        String filename = null;
        if (contentHeader != null && (values = contentHeader.getElements()).length == 1 && (param = values[0].getParameterByName("filename")) != null) {
            try {
                filename = param.getValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filename;
    }
}

