/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.OlineUserTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommTreeUtils {
    private static final Logger log = LoggerFactory.getLogger(CommTreeUtils.class);
    private static final int MAX_LOOP_COUNT = 10000;

    public static List<ComBoxTreeNode> listToNodeList(List list) {
        ArrayList<ComBoxTreeNode> nodes = new ArrayList<ComBoxTreeNode>();
        for (Object object : list) {
            Map row = (Map)object;
            ComBoxTreeNode node = new ComBoxTreeNode();
            CommTreeUtils.fillTreeNodeProperty(node, row);
            node.setState(MapUtils.getString((Map)row, (Object)"state", (String)MapUtils.getString((Map)row, (Object)"STATE")));
            nodes.add(node);
        }
        return nodes;
    }

    public static List<Map<String, Object>> buildTreeMap(List<Map<String, Object>> list) {
        list = new ArrayList<Map<String, Object>>(list);
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> idmap = new HashMap<String, Integer>();
        for (int i = list.size() - 1; i >= 0; --i) {
            Map<String, Object> row = list.get(i);
            idmap.put(MapUtils.getString(row, (Object)"id", (String)MapUtils.getString(row, (Object)"ID")), i);
        }
        for (Map<String, Object> object : list) {
            Map<String, Object> map = object;
            if (idmap.containsKey(MapUtils.getString(map, (Object)"pid", (String)MapUtils.getString(map, (Object)"PID")))) continue;
            maps.add(map);
        }
        ArrayList<Map<String, Object>> todo = new ArrayList<Map<String, Object>>();
        for (Map map : maps) {
            todo.add(map);
        }
        long loop = todo.size();
        while (!todo.isEmpty()) {
            Map pMap = (Map)todo.get(0);
            todo.remove(0);
            Iterator<Map<String, Object>> it = list.iterator();
            while (it.hasNext()) {
                Map<String, Object> row = it.next();
                if (!MapUtils.getString((Map)pMap, (Object)"id", (String)MapUtils.getString(row, (Object)"ID")).equals(MapUtils.getString(row, (Object)"pid", (String)MapUtils.getString(row, (Object)"PID")))) continue;
                if (!pMap.containsKey("children")) {
                    ArrayList<Map<String, Object>> childrenlist = new ArrayList<Map<String, Object>>();
                    childrenlist.add(row);
                    pMap.put("children", childrenlist);
                } else {
                    ((List)pMap.get("children")).add(row);
                }
                todo.add(row);
                it.remove();
            }
            if (loop++ <= 10000L) continue;
            log.warn("\u5faa\u73af\u6b21\u6570\u8d85\u8fc710000\u6b21,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e,\u82e5\u6570\u636e\u8d85\u51fa1W\u5efa\u8bae\u4f7f\u7528\u5f02\u6b65\u6811");
            break;
        }
        return maps;
    }

    public static List<ComBoxTreeNode> buildTreeNode(List list) {
        list = new ArrayList(list);
        ArrayList<ComBoxTreeNode> nodes = new ArrayList<ComBoxTreeNode>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = list.size() - 1; i >= 0; --i) {
            Map row = (Map)list.get(i);
            map.put(MapUtils.getString((Map)row, (Object)"id", (String)MapUtils.getString((Map)row, (Object)"ID")), i);
        }
        for (Object object : list) {
            Map row = (Map)object;
            if (map.containsKey(MapUtils.getString((Map)row, (Object)"pid", (String)MapUtils.getString((Map)row, (Object)"PID")))) continue;
            ComBoxTreeNode node = new ComBoxTreeNode();
            CommTreeUtils.fillTreeNodeProperty(node, row);
            nodes.add(node);
        }
        ArrayList<ComBoxTreeNode> todo = new ArrayList<ComBoxTreeNode>();
        for (ComBoxTreeNode item : nodes) {
            todo.add(item);
        }
        long loop = todo.size();
        while (!todo.isEmpty()) {
            ComBoxTreeNode pNode = (ComBoxTreeNode)todo.get(0);
            todo.remove(0);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Map row = (Map)it.next();
                if (!pNode.getId().equals(MapUtils.getString((Map)row, (Object)"pid", (String)MapUtils.getString((Map)row, (Object)"PID")))) continue;
                ComBoxTreeNode child = new ComBoxTreeNode();
                CommTreeUtils.fillTreeNodeProperty(child, row);
                if (pNode.getChildren() == null || pNode.getChildren().size() < 1) {
                    ArrayList<ComBoxTreeNode> childrenlist = new ArrayList<ComBoxTreeNode>();
                    childrenlist.add(child);
                    pNode.setChildren(childrenlist);
                } else {
                    pNode.getChildren().add(child);
                }
                todo.add(child);
                it.remove();
            }
            if (loop++ <= 10000L) continue;
            log.warn("\u5faa\u73af\u6b21\u6570\u8d85\u8fc710000\u6b21,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e,\u82e5\u6570\u636e\u8d85\u51fa1W\u5efa\u8bae\u4f7f\u7528\u5f02\u6b65\u6811");
            break;
        }
        return nodes;
    }

    public static ComBoxTreeNode fillTreeNodeProperty(ComBoxTreeNode node, Map row) {
        node.setId(MapUtils.getString((Map)row, (Object)"id", (String)MapUtils.getString((Map)row, (Object)"ID")));
        node.setText(MapUtils.getString((Map)row, (Object)"text", (String)MapUtils.getString((Map)row, (Object)"TEXT")));
        node.setIconCls(MapUtils.getString((Map)row, (Object)"ico", (String)MapUtils.getString((Map)row, (Object)"ICO")));
        node.setValue(MapUtils.getString((Map)row, (Object)"value", (String)MapUtils.getString((Map)row, (Object)"VALUE")));
        node.setChecked("1".equals(MapUtils.getString((Map)row, (Object)"checked", (String)MapUtils.getString((Map)row, (Object)"CHECKED"))));
        node.setState(MapUtils.getString((Map)row, (Object)"state", (String)MapUtils.getString((Map)row, (Object)"STATE")));
        for (Map.Entry entry : row.entrySet()) {
            String keystr = entry.getKey().toString().toLowerCase();
            node.addAttributes(keystr, row.get(entry.getKey()));
        }
        return node;
    }

    public static void setLeafForComTree(List<ComBoxTreeNode> resultNodes) {
    }

    public static boolean exists(List list, String pid) {
        for (Object object : list) {
            Map row = (Map)object;
            if (!pid.equals(MapUtils.getString((Map)row, (Object)"id", (String)MapUtils.getString((Map)row, (Object)"ID")))) continue;
            return true;
        }
        return false;
    }

    public static Map<String, OlineUserTreeNode> buildOnlineNodeTree(List list) {
        HashMap<String, OlineUserTreeNode> nodeMap = new HashMap<String, OlineUserTreeNode>();
        return nodeMap;
    }
}

