/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.support;

import java.util.HashMap;
import java.util.Map;

public enum FileType {
    PICTURE,
    COMPRESS,
    OFFICE,
    SIMTEXT,
    PDF,
    CODE,
    OTHER,
    MEDIA,
    MARKDOWN,
    XML,
    FLV,
    CAD,
    TIFF,
    OFD;

    private static final String[] OFFICE_TYPES;
    private static final String[] PICTURE_TYPES;
    private static final String[] ARCHIVE_TYPES;
    private static final String[] TIFF_TYPES;
    private static final String[] OFD_TYPES;
    private static final String[] CODES;
    private static final Map<String, FileType> FILE_TYPE_MAPPER;

    private static FileType to(String fileType) {
        return FILE_TYPE_MAPPER.getOrDefault(fileType, OTHER);
    }

    public static FileType typeFromUrl(String url) {
        String nonPramStr = url.substring(0, url.contains("?") ? url.indexOf("?") : url.length());
        String fileName = nonPramStr.substring(nonPramStr.lastIndexOf("/") + 1);
        return FileType.typeFromFileName(fileName);
    }

    public static FileType typeFromFileName(String fileName) {
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String lowerCaseFileType = fileType.toLowerCase();
        return FileType.to(lowerCaseFileType);
    }

    static {
        OFFICE_TYPES = new String[]{"docx", "wps", "doc", "xls", "xlsx", "ppt", "pptx"};
        PICTURE_TYPES = new String[]{"jpg", "jpeg", "png", "gif", "bmp", "ico", "raw"};
        ARCHIVE_TYPES = new String[]{"rar", "zip", "jar", "7-zip", "tar", "gzip", "7z", "war", "wim"};
        TIFF_TYPES = new String[]{"tif", "tiff"};
        OFD_TYPES = new String[]{"ofd"};
        CODES = new String[]{"java", "c", "php", "go", "python", "py", "js", "html", "ftl", "css", "lua", "sh", "rb", "yaml", "yml", "json", "h", "cpp", "cs", "aspx", "jsp"};
        FILE_TYPE_MAPPER = new HashMap<String, FileType>();
        for (String office : OFFICE_TYPES) {
            FILE_TYPE_MAPPER.put(office, OFFICE);
        }
        for (String picture : PICTURE_TYPES) {
            FILE_TYPE_MAPPER.put(picture, PICTURE);
        }
        for (String archive : ARCHIVE_TYPES) {
            FILE_TYPE_MAPPER.put(archive, COMPRESS);
        }
        for (String tif : TIFF_TYPES) {
            FILE_TYPE_MAPPER.put(tif, TIFF);
        }
        for (String code : CODES) {
            FILE_TYPE_MAPPER.put(code, CODE);
        }
        for (String ofd : OFD_TYPES) {
            FILE_TYPE_MAPPER.put(ofd, OFD);
        }
        FILE_TYPE_MAPPER.put("md", MARKDOWN);
        FILE_TYPE_MAPPER.put("xml", XML);
        FILE_TYPE_MAPPER.put("pdf", PDF);
        FILE_TYPE_MAPPER.put("dwg", CAD);
        FILE_TYPE_MAPPER.put("flv", FLV);
    }
}

