/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.spring;

import com.guochuang.imp.base.common.util.MemCache;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class ZcInterfaceInteceptor
implements HandlerInterceptor {
    private static Logger logger = LoggerFactory.getLogger(ZcInterfaceInteceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String clientIp = this.getClientIp(request);
        Set<String> whitelist = MemCache.getDicStrSet("ZC_IP_WHITELIST");
        if (whitelist != null && whitelist.contains(clientIp)) {
            return true;
        }
        if (whitelist == null || whitelist.size() == 0) {
            logger.warn("Access denied for IP: {}\uff0c\u767d\u540d\u5355\u5b57\u5178ZC_IP_WHITELIST\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e", (Object)clientIp);
            response.sendError(403, "Your IP is not allowed,Please contact project manager!");
            return false;
        }
        logger.warn("Access denied for IP: {}", (Object)clientIp);
        response.sendError(403, "Your IP is not allowed,Please contact project manager!");
        return false;
    }

    private String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.contains(",")) {
            ip = ip.split(",")[0].trim();
        }
        return ip;
    }
}

