/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.interceptor.repeat;

import com.guochuang.imp.base.common.interceptor.repeat.RepeatSubmit;
import com.guochuang.imp.base.common.interceptor.repeat.RepeatSubmitException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public abstract class RepeatSubmitInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(RepeatSubmitInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            RepeatSubmit annotation = method.getAnnotation(RepeatSubmit.class);
            if (annotation != null && this.isRepeatSubmit(request, annotation)) {
                String url = request.getRequestURI();
                log.error("\u91cd\u590d\u63d0\u4ea4\u8868\u5355 uri = {}", (Object)url);
                throw new RepeatSubmitException(annotation.message());
            }
            return true;
        }
        return super.preHandle(request, response, handler);
    }

    public abstract boolean isRepeatSubmit(HttpServletRequest var1, RepeatSubmit var2);
}

