/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.license.spring.boot.autoconfigure.stat;

import com.guochuang.license.spring.boot.autoconfigure.LicenseCheckModel;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerInfos {
    private static Logger logger = LoggerFactory.getLogger(AbstractServerInfos.class);

    public LicenseCheckModel getServerInfos() {
        LicenseCheckModel result = new LicenseCheckModel();
        try {
            result.setIpAddress(this.getIpAddress());
            result.setMacAddress(this.getMacAddress());
            result.setCpuSerial(this.getCPUSerial());
            result.setMainBoardSerial(this.getMainBoardSerial());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u670d\u52a1\u5668\u786c\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    protected abstract List<String> getIpAddress() throws Exception;

    protected abstract List<String> getMacAddress() throws Exception;

    protected abstract String getCPUSerial() throws Exception;

    protected abstract String getMainBoardSerial() throws Exception;

    protected List<InetAddress> getLocalAllInetAddress() throws Exception {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>(4);
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface iface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddr = inetAddresses.nextElement();
                if (inetAddr.isLoopbackAddress() || inetAddr.isLinkLocalAddress() || inetAddr.isMulticastAddress()) continue;
                result.add(inetAddr);
            }
        }
        return result;
    }

    protected String getMacByInetAddress(InetAddress inetAddr) {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < mac.length; ++i) {
                String temp;
                if (i != 0) {
                    stringBuffer.append("-");
                }
                if ((temp = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                    stringBuffer.append("0").append(temp);
                    continue;
                }
                stringBuffer.append(temp);
            }
            return stringBuffer.toString().toUpperCase();
        }
        catch (Exception e) {
            logger.error("getByInetAddress error", (Throwable)e);
            return null;
        }
    }
}

