/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.license.spring.boot.autoconfigure;

import cn.hutool.extra.spring.SpringUtil;
import com.guochuang.license.spring.boot.autoconfigure.LicenseVerify;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ContentModifierFilter
implements Filter {
    private LicenseVerify LicenseVerify;
    private static final String WATERMARK_JS = "<script> function createWatermark(text, fontSize = '16px', color = 'rgba(0,0,0,%f)', rotate = -30) {\n     const watermark = document.createElement('div');\n    watermark.id = 'watermark';\n    watermark.style.position = 'fixed';\n    watermark.style.top = '0';\n    watermark.style.left = '0';\n    watermark.style.width = '100%%';\n    watermark.style.height = '100%%';\n    watermark.style.pointerEvents = 'none';\n    watermark.style.zIndex = '9999';\n    watermark.style.opacity = '0.5';\n    const canvas = document.createElement('canvas');\n    const ctx = canvas.getContext('2d');\n    canvas.width = 380;\n    canvas.height = 300;\n    // \u6e05\u9664\u9ed8\u8ba4\u53d8\u6362\n    ctx.clearRect(0, 0, canvas.width, canvas.height);\n    // \u79fb\u52a8\u753b\u5e03\u539f\u70b9\u5230\u4e2d\u5fc3\uff0c\u518d\u65cb\u8f6c\uff08\u907f\u514d\u65cb\u8f6c\u540e\u79fb\u51fa\uff09\n    ctx.translate(canvas.width / 2, canvas.height / 2);\n    ctx.rotate(rotate * Math.PI / 180);\n    ctx.translate(-canvas.width / 2, -canvas.height / 2);\n    // \u8bbe\u7f6e\u5b57\u4f53\u548c\u989c\u8272\n    ctx.font = `${fontSize} Arial`;\n    ctx.fillStyle = color;\n    ctx.textAlign = 'center';\n    ctx.textBaseline = 'middle';\n    // \u5728\u753b\u5e03\u4e2d\u5fc3\u7ed8\u5236\u6587\u672c\n    const x = canvas.width / 2;\n    const y = canvas.height / 2;\n    ctx.fillText(text, x, y);\n    \n    watermark.style.backgroundImage = `url(${canvas.toDataURL()})`;\n    watermark.style.backgroundRepeat = 'repeat';\n    document.body.appendChild(watermark);\n}  createWatermark('%s');</script>";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if ("/".equals(req.getServletPath())) {
            chain.doFilter(request, response);
            return;
        }
        if (this.LicenseVerify == null) {
            this.LicenseVerify = (LicenseVerify)SpringUtil.getBean((String)"licenseVerify");
        }
        if (this.LicenseVerify == null || this.LicenseVerify.getRestDay() > 90L) {
            chain.doFilter(request, response);
            return;
        }
        CharResponseWrapper wrapper = new CharResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrapper);
        try {
            String contentType = wrapper.getContentType();
            if (contentType == null || !contentType.startsWith("text/html")) {
                return;
            }
            String content = wrapper.getContent();
            if (content.contains("<body") && content.contains("</body>")) {
                String watermarkText = this.generateWatermarkText(this.LicenseVerify.getRestDay());
                String watermarkScript = String.format(WATERMARK_JS, (double)(100L - this.LicenseVerify.getRestDay()) / 150.0, watermarkText);
                content = content.replace("</body>", watermarkScript + "</body>");
            }
            response.setContentLength(content.length());
            response.getWriter().write(content);
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String generateWatermarkText(Long restDay) {
        return restDay == 0L ? "\u7cfb\u7edf\u4e34\u65f6\u6388\u6743\u5df2\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u7533\u8bf7\u6b63\u5f0f\u6388\u6743\u4ee5\u514d\u5f71\u54cd\u4f7f\u7528" : "\u5f53\u524d\u7cfb\u7edf\u4e3a\u4e34\u65f6\u6388\u6743\uff0c\u5269\u4f59\u6388\u6743\u65f6\u95f4" + restDay + "\u5929";
    }

    private static class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private final CharArrayWriter output = new CharArrayWriter();

        public CharResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() {
            return new PrintWriter(this.output);
        }

        public String getContent() {
            return this.output.toString();
        }
    }
}

