/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.cache.FileBackedIndex;
import com.googlecode.download.maven.plugin.internal.cache.FileIndex;
import com.googlecode.download.maven.plugin.internal.signature.Signatures;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.codec.digest.DigestUtils;

public final class DownloadCache {
    private final File basedir;
    private final FileIndex index;

    public DownloadCache(File cacheDirectory) {
        DownloadCache.createIfNeeded(cacheDirectory);
        this.index = new FileBackedIndex(cacheDirectory);
        this.basedir = cacheDirectory;
    }

    private String getEntry(URI uri, Signatures signatures) {
        String res = this.index.get(uri);
        if (res == null) {
            return null;
        }
        File resFile = new File(this.basedir, res);
        if (resFile.isFile() && signatures.isValid(resFile)) {
            return res;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getArtifact(URI uri, Signatures signatures) {
        String res;
        try {
            this.index.getLock().lock();
            res = this.getEntry(uri, signatures);
        }
        finally {
            this.index.getLock().unlock();
        }
        if (res != null) {
            return new File(this.basedir, res);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(URI uri, File outputFile, Signatures signatures) throws Exception {
        try {
            this.index.getLock().lock();
            String entry = this.getEntry(uri, signatures);
            if (entry != null) {
                return;
            }
            String fileName = String.format("%s_%s", outputFile.getName(), DigestUtils.md5Hex((String)uri.toString()));
            Files.copy(outputFile.toPath(), new File(this.basedir, fileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.index.put(uri, fileName);
        }
        finally {
            this.index.getLock().unlock();
        }
    }

    private static void createIfNeeded(File basedir) {
        if (!basedir.exists()) {
            basedir.mkdirs();
        } else if (!basedir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Cannot use %s as cache directory: a file already exist there", basedir));
        }
    }
}

