/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.googlecode.download.maven.plugin.internal.ProgressReport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;

public class HttpFileRequester {
    private final CloseableHttpClient httpClient;
    private final ProgressReport progressReport;

    public HttpFileRequester(CloseableHttpClient httpClient, ProgressReport progressReport) {
        this.httpClient = httpClient;
        this.progressReport = progressReport;
    }

    public void download(final URI uri, final File outputFile, HttpContext clientContext, List<Header> headers) throws Exception {
        HttpGet httpGet = new HttpGet(uri);
        headers.forEach(arg_0 -> ((HttpGet)httpGet).setHeader(arg_0));
        this.httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws IOException {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    HttpFileRequester.this.progressReport.initiate(uri, entity.getContentLength());
                    byte[] tmp = new byte[88192];
                    try (InputStream in = entity.getContent();
                         FileOutputStream out = new FileOutputStream(outputFile);){
                        int bytesRead;
                        while ((bytesRead = in.read(tmp)) != -1) {
                            ((OutputStream)out).write(tmp, 0, bytesRead);
                            HttpFileRequester.this.progressReport.update(bytesRead);
                        }
                        out.flush();
                        HttpFileRequester.this.progressReport.completed();
                    }
                    catch (IOException ex) {
                        HttpFileRequester.this.progressReport.error(ex);
                        throw ex;
                    }
                }
                return null;
            }
        }, clientContext);
    }
}

