/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.googlecode.download.maven.plugin.internal.ConsoleDownloadMonitor;
import com.googlecode.download.maven.plugin.internal.DownloadCache;
import com.googlecode.download.maven.plugin.internal.SignatureUtils;
import java.io.File;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.MessageDigest;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="wget", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=false)
public class WGet
extends AbstractMojo {
    @Parameter(property="download.url", required=true)
    private String url;
    @Parameter(property="download.overwrite")
    private boolean overwrite;
    @Parameter(property="download.outputFileName")
    private String outputFileName;
    @Parameter(property="download.outputDirectory", defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter
    private String md5;
    @Parameter
    private String sha1;
    @Parameter
    private String sha512;
    @Parameter(defaultValue="false")
    private boolean unpack;
    @Parameter
    private String username;
    @Parameter
    private String password;
    @Parameter(defaultValue="2")
    private int retries;
    @Parameter(defaultValue="0")
    private int readTimeOut;
    @Parameter(defaultValue="false")
    private boolean skipCache;
    @Parameter(property="download.cache.directory")
    private File cacheDirectory;
    @Parameter(defaultValue="true")
    private boolean failOnError;
    @Parameter(property="download.plugin.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="checkSignature", defaultValue="false")
    private boolean checkSignature;
    @Parameter(property="session")
    private MavenSession session;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private WagonManager wagonManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"maven-download-plugin:wget skipped");
            return;
        }
        if (this.retries < 1) {
            throw new MojoFailureException("retries must be at least 1");
        }
        if (this.outputFileName == null) {
            try {
                this.outputFileName = new File(new URL(this.url).getFile()).getName();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Invalid URL", ex);
            }
        }
        if (this.cacheDirectory == null) {
            this.cacheDirectory = new File(this.session.getLocalRepository().getBasedir(), ".cache/download-maven-plugin");
        }
        this.getLog().debug((CharSequence)("Cache is: " + this.cacheDirectory.getAbsolutePath()));
        DownloadCache cache = new DownloadCache(this.cacheDirectory);
        this.outputDirectory.mkdirs();
        File outputFile = new File(this.outputDirectory, this.outputFileName);
        try {
            boolean haveFile = outputFile.exists();
            if (haveFile) {
                boolean signatureMatch = true;
                if (this.checkSignature) {
                    String expectedDigest = null;
                    String algorithm = null;
                    if (this.md5 != null) {
                        expectedDigest = this.md5;
                        algorithm = "MD5";
                    }
                    if (this.sha1 != null) {
                        expectedDigest = this.sha1;
                        algorithm = "SHA1";
                    }
                    if (this.sha512 != null) {
                        expectedDigest = this.sha512;
                        algorithm = "SHA-512";
                    }
                    if (expectedDigest != null) {
                        try {
                            SignatureUtils.verifySignature(outputFile, expectedDigest, MessageDigest.getInstance(algorithm));
                        }
                        catch (MojoFailureException e) {
                            this.getLog().warn((CharSequence)("The local version of file " + outputFile.getName() + " doesn't match the expected signature. " + "You should consider checking the specified signature is correctly set."));
                            signatureMatch = false;
                        }
                    }
                }
                if (!signatureMatch) {
                    outputFile.delete();
                    haveFile = false;
                } else if (!this.overwrite) {
                    this.getLog().info((CharSequence)"File already exist, skipping");
                }
            }
            if (!haveFile) {
                File cached = cache.getArtifact(this.url, this.md5, this.sha1, this.sha512);
                if (!this.skipCache && cached != null && cached.exists()) {
                    this.getLog().info((CharSequence)("Got from cache: " + cached.getAbsolutePath()));
                    Files.copy(cached.toPath(), outputFile.toPath(), new CopyOption[0]);
                } else {
                    boolean done = false;
                    while (!done && this.retries > 0) {
                        try {
                            this.doGet(outputFile);
                            if (this.md5 != null) {
                                SignatureUtils.verifySignature(outputFile, this.md5, MessageDigest.getInstance("MD5"));
                            }
                            if (this.sha1 != null) {
                                SignatureUtils.verifySignature(outputFile, this.sha1, MessageDigest.getInstance("SHA1"));
                            }
                            if (this.sha512 != null) {
                                SignatureUtils.verifySignature(outputFile, this.sha512, MessageDigest.getInstance("SHA-512"));
                            }
                            done = true;
                        }
                        catch (Exception ex) {
                            this.getLog().warn((CharSequence)"Could not get content", (Throwable)ex);
                            --this.retries;
                            if (this.retries <= 0) continue;
                            this.getLog().warn((CharSequence)("Retrying (" + this.retries + " more)"));
                        }
                    }
                    if (!done) {
                        if (this.failOnError) {
                            throw new MojoFailureException("Could not get content");
                        }
                        this.getLog().warn((CharSequence)"Not failing download despite download failure.");
                        return;
                    }
                }
            }
            cache.install(this.url, outputFile, this.md5, this.sha1, this.sha512);
            if (this.unpack) {
                this.unpack(outputFile);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("IO Error", ex);
        }
    }

    private void unpack(File outputFile) throws NoSuchArchiverException {
        UnArchiver unarchiver = this.archiverManager.getUnArchiver(outputFile);
        unarchiver.setSourceFile(outputFile);
        unarchiver.setDestDirectory(this.outputDirectory);
        unarchiver.extract();
        outputFile.delete();
    }

    private void doGet(File outputFile) throws Exception {
        String[] segments = this.url.split("/");
        String file = segments[segments.length - 1];
        String repoUrl = this.url.substring(0, this.url.length() - file.length() - 1);
        Repository repository = new Repository(repoUrl, repoUrl);
        Wagon wagon = this.wagonManager.getWagon(repository.getProtocol());
        if (this.readTimeOut > 0) {
            wagon.setReadTimeout(this.readTimeOut);
            this.getLog().info((CharSequence)("Read Timeout is set to " + this.readTimeOut + " milliseconds (apprx " + Math.round((double)this.readTimeOut * 1.66667E-5) + " minutes)"));
        }
        ConsoleDownloadMonitor downloadMonitor = null;
        if (this.session.getSettings().isInteractiveMode()) {
            downloadMonitor = new ConsoleDownloadMonitor();
            wagon.addTransferListener((TransferListener)downloadMonitor);
        }
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        if (StringUtils.isNotBlank((String)this.username)) {
            this.getLog().debug((CharSequence)"providing custom authentication");
            this.getLog().debug((CharSequence)("username: " + this.username + " and password: ***"));
            authenticationInfo.setUserName(this.username);
            authenticationInfo.setPassword(this.password);
        }
        ProxyInfo proxyInfo = this.wagonManager.getProxy(repository.getProtocol());
        wagon.connect(repository, authenticationInfo, proxyInfo);
        wagon.get(file, outputFile);
        wagon.disconnect();
        if (downloadMonitor != null) {
            wagon.removeTransferListener((TransferListener)downloadMonitor);
        }
    }
}

