/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.script.jexl;

import com.agapple.mapping.process.script.lifecyle.DisposableScript;
import com.agapple.mapping.process.script.lifecyle.InitializingScript;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.jexl2.Interpreter;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.parser.JexlNode;

class ScriptJexlEngine
extends JexlEngine {
    private ThreadLocal<Set<Object>> usedFunctions = new ThreadLocal<Set<Object>>(){

        @Override
        protected Set<Object> initialValue() {
            return new HashSet<Object>();
        }
    };

    public ScriptJexlEngine() {
        super(null, null, null, null);
    }

    protected Interpreter createInterpreter(JexlContext context) {
        if (context == null) {
            context = EMPTY_CONTEXT;
        }
        return new ScriptInterpreter(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeUsedFunctions() {
        try {
            Set<Object> functions = this.usedFunctions.get();
            for (Object function : functions) {
                if (function == null || !DisposableScript.class.isAssignableFrom(function.getClass())) continue;
                ((DisposableScript)function).dispose();
            }
        }
        finally {
            this.usedFunctions.set(new HashSet());
        }
    }

    class ScriptInterpreter
    extends Interpreter {
        public ScriptInterpreter(JexlEngine jexl, JexlContext aContext) {
            super(jexl, aContext);
        }

        protected Object resolveNamespace(String prefix, JexlNode node) {
            boolean contains;
            Object result = super.resolveNamespace(prefix, node);
            if (result != null && (contains = ((Set)ScriptJexlEngine.this.usedFunctions.get()).add(result)) && InitializingScript.class.isAssignableFrom(result.getClass())) {
                ((InitializingScript)result).initial();
            }
            return result;
        }
    }
}

