/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.script;

import com.agapple.mapping.core.helper.ReflectionHelper;
import com.agapple.mapping.process.script.ScriptExecutor;
import com.agapple.mapping.process.script.jexl.JexlScriptExecutor;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ScriptHelper {
    private static final String DEFAULT_SCRIPT = JexlScriptExecutor.class.getName();
    private static final String property = "BeanMapping.Script.Executor";
    private static volatile ScriptHelper singleton = null;
    private volatile ScriptExecutor executor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScriptHelper getInstance() {
        if (singleton != null) return singleton;
        Class<ScriptHelper> clazz = ScriptHelper.class;
        synchronized (ScriptHelper.class) {
            if (singleton != null) return singleton;
            singleton = new ScriptHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScriptExecutor getScriptExecutor() {
        if (this.executor != null) return this.executor;
        Class<ScriptHelper> clazz = ScriptHelper.class;
        synchronized (ScriptHelper.class) {
            if (this.executor != null) return this.executor;
            this.executor = this.createScriptExecutor();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.executor;
        }
    }

    public void registerFunctionClass(String name, Object function) {
        this.getScriptExecutor().addFunction(name, function);
    }

    public void batchRegisterFunctionClass(Map<String, Object> functions) {
        if (functions != null && functions.size() > 0) {
            for (Map.Entry<String, Object> entry : functions.entrySet()) {
                this.registerFunctionClass(entry.getKey(), entry.getValue());
            }
        }
    }

    private ScriptExecutor createScriptExecutor() {
        String className = null;
        ClassLoader loader = ScriptExecutor.class.getClassLoader();
        try {
            className = System.getProperty(property);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        if (StringUtils.isEmpty((String)className)) {
            try {
                String service = "META-INF/services/BeanMapping.Script.Executor";
                InputStream in = loader == null ? ClassLoader.getSystemResourceAsStream(service) : loader.getResourceAsStream(service);
                if (in != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, System.getProperty("file.encoding", "UTF-8")));
                    className = reader.readLine();
                    in.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (className == null) {
            className = DEFAULT_SCRIPT;
        }
        Class clazz = ReflectionHelper.forName(className, loader);
        return (ScriptExecutor)ReflectionHelper.newInstance(clazz);
    }
}

