/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.convertor;

import com.agapple.mapping.process.convertor.CollectionAndCollectionConvertor;
import com.agapple.mapping.process.convertor.CommonAndCommonConvertor;
import com.agapple.mapping.process.convertor.Convertor;
import com.agapple.mapping.process.convertor.ConvertorRepository;
import com.agapple.mapping.process.convertor.SqlDateAndDateConvertor;
import com.agapple.mapping.process.convertor.StringAndCommonConvertor;
import com.agapple.mapping.process.convertor.StringAndDateConvertor;
import com.agapple.mapping.process.convertor.StringAndEnumConvertor;
import com.agapple.mapping.process.convertor.StringAndObjectConvertor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

public class ConvertorHelper {
    public static final String ALIAS_DATE_TIME_TO_STRING = StringAndDateConvertor.DateTimeToString.class.getSimpleName();
    public static final String ALIAS_DATE_DAY_TO_STRING = StringAndDateConvertor.DateDayToString.class.getSimpleName();
    public static final String ALIAS_STRING_TO_DATE_TIME = StringAndDateConvertor.StringToDateTime.class.getSimpleName();
    public static final String ALIAS_STRING_TO_DATE_DAY = StringAndDateConvertor.StringToDateDay.class.getSimpleName();
    public static final String ALIAS_CALENDAR_TIME_TO_STRING = StringAndDateConvertor.CalendarTimeToString.class.getSimpleName();
    public static final String ALIAS_CALENDAR_DAY_TO_STRING = StringAndDateConvertor.CalendarDayToString.class.getSimpleName();
    public static final String ALIAS_STRING_TO_CALENDAR_TIME = StringAndDateConvertor.StringToCalendarTime.class.getSimpleName();
    public static final String ALIAS_STRING_TO_CALENDAR_DAY = StringAndDateConvertor.StringToCalendarDay.class.getSimpleName();
    private static Map<Class, Object> commonTypes = new HashMap<Class, Object>();
    private static final Convertor stringToCommon = new StringAndCommonConvertor.StringToCommon();
    private static final Convertor commonToCommon = new CommonAndCommonConvertor.CommonToCommon();
    private static final Convertor arrayToArray = new CollectionAndCollectionConvertor.ArrayToArray();
    private static final Convertor arrayToCollection = new CollectionAndCollectionConvertor.ArrayToCollection();
    private static final Convertor collectionToArray = new CollectionAndCollectionConvertor.CollectionToArray();
    private static final Convertor collectionToCollection = new CollectionAndCollectionConvertor.CollectionToCollection();
    private static final Convertor objectToString = new StringAndObjectConvertor.ObjectToString();
    private static final Convertor stringToEnum = new StringAndEnumConvertor.StringToEnum();
    private static final Convertor enumToString = new StringAndEnumConvertor.EnumToString();
    private static final Convertor sqlToDate = new SqlDateAndDateConvertor.SqlDateToDateConvertor();
    private static final Convertor dateToSql = new SqlDateAndDateConvertor.DateToSqlDateConvertor();
    private static volatile ConvertorHelper singleton = null;
    private ConvertorRepository repository = null;

    public ConvertorHelper() {
        this.repository = new ConvertorRepository();
        this.initDefaultRegister();
    }

    public ConvertorHelper(ConvertorRepository repository) {
        this.repository = repository;
        this.initDefaultRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConvertorHelper getInstance() {
        if (singleton != null) return singleton;
        Class<ConvertorHelper> clazz = ConvertorHelper.class;
        synchronized (ConvertorHelper.class) {
            if (singleton != null) return singleton;
            singleton = new ConvertorHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public Convertor getConvertor(Class src, Class dest) {
        if (src == dest) {
            return null;
        }
        Convertor convertor = this.repository.getConvertor(src, dest);
        boolean isSrcArray = src.isArray();
        boolean isDestArray = dest.isArray();
        if (convertor == null && src.isArray() && dest.isArray()) {
            convertor = arrayToArray;
        } else {
            boolean isSrcCollection = Collection.class.isAssignableFrom(src);
            boolean isDestCollection = Collection.class.isAssignableFrom(dest);
            if (convertor == null && isSrcArray && isDestCollection) {
                convertor = arrayToCollection;
            }
            if (convertor == null && isDestArray && isSrcCollection) {
                convertor = collectionToArray;
            }
            if (convertor == null && isSrcCollection && isDestCollection) {
                convertor = collectionToCollection;
            }
        }
        if (convertor == null && dest == String.class) {
            convertor = src.isEnum() ? enumToString : objectToString;
        }
        if (convertor == null && src == String.class) {
            if (commonTypes.containsKey(dest)) {
                convertor = stringToCommon;
            } else if (dest.isEnum()) {
                convertor = stringToEnum;
            }
        }
        if (convertor == null && commonTypes.containsKey(src) && commonTypes.containsKey(dest)) {
            convertor = commonToCommon;
        }
        return convertor;
    }

    public Convertor getConvertor(String alias) {
        return this.repository.getConvertor(alias);
    }

    public void registerConvertor(Class src, Class dest, Convertor convertor) {
        this.repository.registerConvertor(src, dest, convertor);
    }

    public void registerConvertor(String alias, Convertor convertor) {
        this.repository.registerConvertor(alias, convertor);
    }

    public void initDefaultRegister() {
        this.initCommonTypes();
        this.StringDateRegister();
    }

    private void StringDateRegister() {
        StringAndDateConvertor.StringToDateDay stringToDateDay = new StringAndDateConvertor.StringToDateDay();
        StringAndDateConvertor.StringToDateTime stringToDateTime = new StringAndDateConvertor.StringToDateTime();
        StringAndDateConvertor.StringToCalendarDay stringToCalendarDay = new StringAndDateConvertor.StringToCalendarDay();
        StringAndDateConvertor.StringToCalendarTime stringToCalendarTime = new StringAndDateConvertor.StringToCalendarTime();
        StringAndDateConvertor.DateDayToString dateDayToString = new StringAndDateConvertor.DateDayToString();
        StringAndDateConvertor.DateTimeToString dateTimeToString = new StringAndDateConvertor.DateTimeToString();
        StringAndDateConvertor.CalendarDayToString calendarDayToString = new StringAndDateConvertor.CalendarDayToString();
        StringAndDateConvertor.CalendarTimeToString calendarTimeToString = new StringAndDateConvertor.CalendarTimeToString();
        this.repository.registerConvertor(String.class, java.util.Date.class, stringToDateTime);
        this.repository.registerConvertor(java.util.Date.class, String.class, dateTimeToString);
        this.repository.registerConvertor(String.class, Calendar.class, stringToCalendarTime);
        this.repository.registerConvertor(Calendar.class, String.class, calendarTimeToString);
        this.repository.registerConvertor(Date.class, java.util.Date.class, sqlToDate);
        this.repository.registerConvertor(Time.class, java.util.Date.class, sqlToDate);
        this.repository.registerConvertor(Timestamp.class, java.util.Date.class, sqlToDate);
        this.repository.registerConvertor(java.util.Date.class, Date.class, dateToSql);
        this.repository.registerConvertor(java.util.Date.class, Time.class, dateToSql);
        this.repository.registerConvertor(java.util.Date.class, Timestamp.class, dateToSql);
        this.repository.registerConvertor(ALIAS_STRING_TO_DATE_DAY, stringToDateDay);
        this.repository.registerConvertor(ALIAS_STRING_TO_DATE_TIME, stringToDateTime);
        this.repository.registerConvertor(ALIAS_STRING_TO_CALENDAR_DAY, stringToCalendarDay);
        this.repository.registerConvertor(ALIAS_STRING_TO_CALENDAR_TIME, stringToCalendarTime);
        this.repository.registerConvertor(ALIAS_DATE_DAY_TO_STRING, dateDayToString);
        this.repository.registerConvertor(ALIAS_DATE_TIME_TO_STRING, dateTimeToString);
        this.repository.registerConvertor(ALIAS_CALENDAR_DAY_TO_STRING, calendarDayToString);
        this.repository.registerConvertor(ALIAS_CALENDAR_TIME_TO_STRING, calendarTimeToString);
    }

    private void initCommonTypes() {
        commonTypes.put(Integer.TYPE, ObjectUtils.NULL);
        commonTypes.put(Integer.class, ObjectUtils.NULL);
        commonTypes.put(Short.TYPE, ObjectUtils.NULL);
        commonTypes.put(Short.class, ObjectUtils.NULL);
        commonTypes.put(Long.TYPE, ObjectUtils.NULL);
        commonTypes.put(Long.class, ObjectUtils.NULL);
        commonTypes.put(Boolean.TYPE, ObjectUtils.NULL);
        commonTypes.put(Boolean.class, ObjectUtils.NULL);
        commonTypes.put(Byte.TYPE, ObjectUtils.NULL);
        commonTypes.put(Byte.class, ObjectUtils.NULL);
        commonTypes.put(Character.TYPE, ObjectUtils.NULL);
        commonTypes.put(Character.class, ObjectUtils.NULL);
        commonTypes.put(Float.TYPE, ObjectUtils.NULL);
        commonTypes.put(Float.class, ObjectUtils.NULL);
        commonTypes.put(Double.TYPE, ObjectUtils.NULL);
        commonTypes.put(Double.class, ObjectUtils.NULL);
        commonTypes.put(BigDecimal.class, ObjectUtils.NULL);
        commonTypes.put(BigInteger.class, ObjectUtils.NULL);
    }

    public void setRepository(ConvertorRepository repository) {
        this.repository = repository;
    }
}

