/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.convertor;

import com.agapple.mapping.BeanCopy;
import com.agapple.mapping.BeanMap;
import com.agapple.mapping.BeanMapping;
import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.config.BeanMappingConfigHelper;
import com.agapple.mapping.core.config.BeanMappingField;
import com.agapple.mapping.core.config.BeanMappingObject;
import com.agapple.mapping.core.helper.ReflectionHelper;
import com.agapple.mapping.process.convertor.AbastactConvertor;
import com.agapple.mapping.process.convertor.CollectionConvertor;
import com.agapple.mapping.process.convertor.ConvertorHelper;
import com.agapple.mapping.process.convertor.MappingConfig;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class CollectionAndCollectionConvertor {

    public static class CollectionToArray
    extends BaseCollectionConvertor {
        @Override
        public Object convertCollection(BeanMappingField context, Object src, Class destClass, Class ... componentClasses) {
            if (Collection.class.isAssignableFrom(src.getClass()) && destClass.isArray()) {
                Collection collection = (Collection)src;
                Class<?> componentDestClass = destClass.getComponentType();
                Object objs = Array.newInstance(componentDestClass, collection.size());
                boolean isInit = false;
                MappingConfig config = null;
                Class componentClass = null;
                if (componentClasses != null && componentClasses.length >= 1) {
                    componentClass = componentClasses[0];
                }
                if (componentDestClass != componentClass) {
                    throw new BeanMappingException("error ComponentClasses config for [" + componentDestClass.getName() + "] to [" + componentDestClass.getName() + "]");
                }
                boolean isForceMapping = false;
                if (context != null) {
                    isForceMapping = StringUtils.isNotEmpty((String)context.getNestName()) || context.getNestObject() != null;
                }
                int i = 0;
                for (Object item : collection) {
                    Class<?> componentSrcClass = item.getClass();
                    if (isForceMapping || componentClass != null && componentSrcClass != componentDestClass) {
                        if (!isInit) {
                            config = this.initMapping(context, componentSrcClass, componentDestClass, componentClasses);
                        }
                        Object newObj = this.doMapping(item, componentDestClass, config);
                        this.arraySet(objs, componentDestClass, i, newObj);
                    } else {
                        this.arraySet(objs, componentDestClass, i, item);
                    }
                    ++i;
                }
                return objs;
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }

        @Override
        protected Class getComponentClass(Object src, Class destClass) {
            if (Collection.class.isAssignableFrom(src.getClass()) && destClass.isArray()) {
                return destClass.getComponentType();
            }
            return null;
        }
    }

    public static class ArrayToCollection
    extends BaseCollectionConvertor {
        @Override
        public Object convertCollection(BeanMappingField context, Object src, Class destClass, Class ... componentClasses) {
            if (src.getClass().isArray() && Collection.class.isAssignableFrom(destClass)) {
                Collection target = this.createCollection(destClass);
                int size = Array.getLength(src);
                Class<?> componentSrcClass = src.getClass().getComponentType();
                MappingConfig config = null;
                Class componentClass = null;
                if (componentClasses != null && componentClasses.length >= 1) {
                    componentClass = componentClasses[0];
                }
                boolean isForceMapping = false;
                if (context != null) {
                    boolean bl = isForceMapping = StringUtils.isNotEmpty((String)context.getNestName()) || context.getNestObject() != null;
                }
                if (isForceMapping || componentClass != null && componentSrcClass != componentClass) {
                    config = this.initMapping(context, componentSrcClass, componentClass, componentClasses);
                }
                for (int i = 0; i < size; ++i) {
                    Object obj = this.arrayGet(src, componentSrcClass, i);
                    if (config != null) {
                        Object newObj = this.doMapping(obj, componentClass, config);
                        target.add(newObj);
                        continue;
                    }
                    target.add(obj);
                }
                return target;
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }

        @Override
        protected Class getComponentClass(Object src, Class destClass) {
            if (src.getClass().isArray() && Collection.class.isAssignableFrom(destClass)) {
                return src.getClass().getComponentType();
            }
            return null;
        }
    }

    public static class ArrayToArray
    extends BaseCollectionConvertor {
        @Override
        public Object convertCollection(BeanMappingField context, Object src, Class destClass, Class ... componentClasses) {
            if (src.getClass().isArray() && destClass.isArray()) {
                int size = Array.getLength(src);
                Class<?> componentSrcClass = src.getClass().getComponentType();
                Class<?> componentDestClass = destClass.getComponentType();
                MappingConfig config = null;
                Object[] objs = (Object[])Array.newInstance(componentDestClass, size);
                Class componentClass = null;
                if (componentClasses != null && componentClasses.length >= 1) {
                    componentClass = componentClasses[0];
                }
                if (componentDestClass != componentClass) {
                    throw new BeanMappingException("error ComponentClasses config for [" + componentDestClass.getName() + "] to [" + componentDestClass.getName() + "]");
                }
                boolean isForceMapping = false;
                if (context != null) {
                    boolean bl = isForceMapping = StringUtils.isNotEmpty((String)context.getNestName()) || context.getNestObject() != null;
                }
                if (isForceMapping || componentClass != null && componentSrcClass != componentClass) {
                    config = this.initMapping(context, componentSrcClass, componentDestClass, componentClasses);
                }
                for (int i = 0; i < size; ++i) {
                    Object obj = this.arrayGet(src, componentSrcClass, i);
                    if (config != null) {
                        Object newObj = this.doMapping(obj, componentDestClass, config);
                        this.arraySet(objs, componentDestClass, i, newObj);
                        continue;
                    }
                    this.arraySet(objs, componentDestClass, i, obj);
                }
                return objs;
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }

        @Override
        protected Class getComponentClass(Object src, Class destClass) {
            if (src.getClass().isArray() && destClass.isArray()) {
                return src.getClass().getComponentType();
            }
            return null;
        }
    }

    public static class CollectionToCollection
    extends BaseCollectionConvertor {
        @Override
        public Object convertCollection(BeanMappingField context, Object src, Class destClass, Class ... componentClasses) {
            if (Collection.class.isAssignableFrom(src.getClass()) && Collection.class.isAssignableFrom(destClass)) {
                Collection collection = (Collection)src;
                Collection target = this.createCollection(destClass);
                boolean isInit = false;
                MappingConfig config = null;
                Class componentClass = null;
                if (componentClasses != null && componentClasses.length >= 1) {
                    componentClass = componentClasses[0];
                }
                boolean isForceMapping = false;
                if (context != null) {
                    isForceMapping = StringUtils.isNotEmpty((String)context.getNestName()) || context.getNestObject() != null;
                }
                for (Object item : collection) {
                    Class<?> componentSrcClass = item.getClass();
                    if (isForceMapping || componentClass != null && componentSrcClass != componentClass) {
                        if (!isInit) {
                            isInit = true;
                            config = this.initMapping(context, componentSrcClass, componentClass, componentClasses);
                        }
                        target.add(this.doMapping(item, componentClass, config));
                        continue;
                    }
                    target.add(item);
                }
                return target;
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }

        @Override
        protected Class getComponentClass(Object src, Class destClass) {
            if (Collection.class.isAssignableFrom(src.getClass()) && Collection.class.isAssignableFrom(destClass)) {
                Collection collection = (Collection)src;
                for (Object item : collection) {
                    if (item == null) continue;
                    return item.getClass();
                }
            }
            return null;
        }
    }

    public static abstract class BaseCollectionConvertor
    extends AbastactConvertor
    implements CollectionConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            return this.convertCollection(src, destClass, this.getComponentClass(src, destClass));
        }

        @Override
        public Object convertCollection(Object src, Class destClass, Class ... componentClasses) {
            return this.convertCollection(null, src, destClass, componentClasses);
        }

        protected abstract Class getComponentClass(Object var1, Class var2);

        protected MappingConfig initMapping(BeanMappingField context, Class srcClass, Class targetClass, Class[] componentClasses) {
            MappingConfig config = new MappingConfig();
            config.convertor = ConvertorHelper.getInstance().getConvertor(srcClass, targetClass);
            if (config.convertor != null) {
                if (componentClasses != null && componentClasses.length > 1) {
                    Class[] newComponentClasses = new Class[componentClasses.length - 1];
                    config.componentClasses = newComponentClasses;
                    System.arraycopy(componentClasses, 1, newComponentClasses, 0, componentClasses.length - 1);
                }
            } else {
                try {
                    if (context != null) {
                        BeanMappingObject object = context.getNestObject();
                        if (object == null) {
                            String nestname = context.getNestName();
                            if (StringUtils.isNotEmpty((String)nestname)) {
                                object = BeanMappingConfigHelper.getInstance().getBeanMappingObject(nestname);
                                config.beanMapping = new BeanMapping(object);
                            } else {
                                config.beanMapping = BeanMapping.create(srcClass, targetClass);
                            }
                        } else {
                            config.beanMapping = new BeanMapping(object);
                        }
                    } else {
                        config.beanMapping = BeanMapping.create(srcClass, targetClass);
                    }
                }
                catch (BeanMappingException e) {
                    boolean isSrcMap = Map.class.isAssignableFrom(srcClass);
                    boolean isTargetMap = Map.class.isAssignableFrom(targetClass);
                    if (isSrcMap && isTargetMap) {
                        config.isMap = true;
                    }
                    if (isSrcMap) {
                        config.beanMap = BeanMap.create(targetClass);
                        config.populate = true;
                    }
                    if (isTargetMap) {
                        config.beanMap = BeanMap.create(srcClass);
                        config.populate = false;
                    }
                    config.beanCopy = BeanCopy.create(srcClass, targetClass);
                }
            }
            return config;
        }

        protected Object doMapping(Object src, Class targetClass, MappingConfig config) {
            Object newObj = null;
            if (config.convertor != null) {
                newObj = config.componentClasses != null && config.convertor instanceof CollectionConvertor ? ((CollectionConvertor)config.convertor).convertCollection(null, src, targetClass, config.componentClasses) : config.convertor.convert(src, targetClass);
            } else if (config.isMap) {
                newObj = this.createMap(targetClass);
                ((Map)newObj).putAll((Map)src);
            } else {
                newObj = ReflectionHelper.newInstance(targetClass);
                if (config.beanMapping != null) {
                    config.beanMapping.mapping(src, newObj);
                } else if (config.beanCopy != null) {
                    config.beanCopy.copy(src, newObj);
                } else if (config.beanMap != null) {
                    if (config.populate) {
                        config.beanMap.populate(newObj, (Map)src);
                    } else {
                        newObj = config.beanMap.describe(src);
                    }
                }
            }
            return newObj;
        }

        protected Map createMap(Class destClass) {
            if (destClass == Map.class || destClass == HashMap.class) {
                return new HashMap();
            }
            if (destClass == TreeMap.class) {
                return new TreeMap();
            }
            if (destClass == LinkedHashMap.class) {
                return new LinkedHashMap();
            }
            throw new BeanMappingException("Unsupported Map: [" + destClass.getName() + "]");
        }

        protected Collection createCollection(Class destClass) {
            if (destClass == List.class || destClass == ArrayList.class) {
                return new ArrayList();
            }
            if (destClass == LinkedList.class) {
                return new LinkedList();
            }
            if (destClass == Vector.class) {
                return new Vector();
            }
            if (destClass == Set.class || destClass == HashSet.class) {
                return new HashSet();
            }
            if (destClass == LinkedHashSet.class) {
                return new LinkedHashSet();
            }
            if (destClass == TreeSet.class) {
                return new TreeSet();
            }
            throw new BeanMappingException("Unsupported Collection: [" + destClass.getName() + "]");
        }

        protected void arraySet(Object src, Class compoentType, int i, Object value) {
            Array.set(src, i, value);
        }

        protected Object arrayGet(Object src, Class compoentType, int i) {
            return Array.get(src, i);
        }
    }
}

