/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.introspect;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.introspect.AbstractExecutor;
import com.agapple.mapping.core.introspect.Introspector;
import com.agapple.mapping.core.introspect.SetExecutor;
import java.lang.reflect.Method;

public class PropertySetExecutor
extends AbstractExecutor
implements SetExecutor {
    private Method method;

    public PropertySetExecutor(Introspector is, Class<?> clazz, String identifier, Class arg) {
        super(clazz, identifier);
        this.method = PropertySetExecutor.discover(is, clazz, identifier, arg);
    }

    @Override
    public Object invoke(Object key, Object value) throws BeanMappingException {
        Object[] pargs = new Object[]{value};
        try {
            this.method.invoke(key, pargs);
            return value;
        }
        catch (Exception e) {
            throw new BeanMappingException(e);
        }
    }

    @Override
    public boolean isAlive() {
        return this.method != null;
    }

    public static Method discover(Introspector is, Class<?> clazz, String property, Class arg) {
        Method method = PropertySetExecutor.discoverSet(is, clazz, property, arg);
        if (method == null && property.startsWith("is")) {
            property = property.substring("is".length());
            method = PropertySetExecutor.discoverSet(is, clazz, property, arg);
        }
        return method;
    }

    public static Method discoverSet(Introspector is, Class<?> clazz, String property, Class arg) {
        String prefix = "set";
        int start = prefix.length();
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(property);
        char c = sb.charAt(start);
        sb.setCharAt(start, Character.toUpperCase(c));
        if (arg == null) {
            Method method = is.getJavaMethod(clazz, sb.toString());
            if (method == null) {
                sb.setCharAt(start, Character.toLowerCase(c));
                method = is.getJavaMethod(clazz, sb.toString());
            }
            return method;
        }
        Method method = is.getJavaMethod(clazz, sb.toString(), arg);
        if (method == null) {
            sb.setCharAt(start, Character.toLowerCase(c));
            method = is.getJavaMethod(clazz, sb.toString(), arg);
        }
        return method;
    }

    public Method getMethod() {
        return this.method;
    }
}

