/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.introspect;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.introspect.AbstractExecutor;
import com.agapple.mapping.core.introspect.GetExecutor;
import com.agapple.mapping.core.introspect.Introspector;
import net.sf.cglib.reflect.FastMethod;

public class FastPropertyGetExecutor
extends AbstractExecutor
implements GetExecutor {
    private FastMethod method;

    public FastPropertyGetExecutor(Introspector is, Class<?> clazz, String identifier) {
        super(clazz, identifier);
        this.method = FastPropertyGetExecutor.discover(is, clazz, identifier);
    }

    @Override
    public Object invoke(Object obj) throws BeanMappingException {
        try {
            return this.method == null ? null : this.method.invoke(obj, (Object[])null);
        }
        catch (Exception e) {
            throw new BeanMappingException(e);
        }
    }

    @Override
    public boolean isAlive() {
        return this.method != null;
    }

    public static FastMethod discover(Introspector is, Class<?> clazz, String property) {
        FastMethod method = FastPropertyGetExecutor.discoverGet(is, "get", clazz, property);
        if (method == null) {
            method = FastPropertyGetExecutor.discoverGet(is, "is", clazz, property);
        }
        return method;
    }

    public static FastMethod discoverGet(Introspector is, String which, Class<?> clazz, String property) {
        FastMethod method = null;
        int start = which.length();
        StringBuilder sb = new StringBuilder(which);
        sb.append(property);
        char c = sb.charAt(start);
        sb.setCharAt(start, Character.toUpperCase(c));
        method = is.getFastMethod(clazz, sb.toString());
        if (method == null) {
            sb.setCharAt(start, Character.toLowerCase(c));
            method = is.getFastMethod(clazz, sb.toString());
        }
        return method;
    }

    public FastMethod getMethod() {
        return this.method;
    }
}

