/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.helper;

import com.agapple.mapping.core.BeanMappingException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.core.ReflectUtils;

public class ReflectionHelper {
    private static String alias_int_name = "int";
    private static String alias_short_name = "short";
    private static String alias_long_name = "long";
    private static String alias_char_name = "char";
    private static String alias_double_name = "double";
    private static String alias_float_name = "float";
    private static String alias_byte_name = "byte";
    private static String alias_bool_name = "boolean";
    private static String alias_string_name = "string";
    private static String alias_map_name = "map";
    private static String alias_list_name = "list";
    private static String alias_set_name = "set";
    private static final Map<Class, Object> primitiveValueMap = new ConcurrentHashMap<Class, Object>(16);
    private static final Map<String, Class> aliasClassMap = new ConcurrentHashMap<String, Class>(16);

    public static void registerClassAlias(String alias, Class clazz) {
        aliasClassMap.put(alias, clazz);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
        BeanInfo beanInfo = null;
        PropertyDescriptor[] descriptors = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    public static Object newInstance(Class type) {
        Constructor<Object> _constructor = null;
        Object[] _constructorArgs = new Object[]{};
        try {
            _constructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (_constructor == null) {
            Constructor<?>[] constructors = type.getConstructors();
            if (constructors.length == 0) {
                throw new UnsupportedOperationException("Class[" + type.getName() + "] has no public constructors");
            }
            _constructor = constructors[0];
            Class<?>[] params = _constructor.getParameterTypes();
            _constructorArgs = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                _constructorArgs[i] = ReflectionHelper.getDefaultValue(params[i]);
            }
        }
        return ReflectUtils.newInstance(_constructor, (Object[])_constructorArgs);
    }

    public static Object getDefaultValue(Class cl) {
        if (cl.isArray()) {
            return Array.newInstance(cl.getComponentType(), 0);
        }
        if (cl.isPrimitive() || primitiveValueMap.containsKey(cl)) {
            return primitiveValueMap.get(cl);
        }
        return ReflectionHelper.newInstance(cl);
    }

    public static Class forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (aliasClassMap.containsKey(className)) {
                return aliasClassMap.get(className);
            }
            throw new BeanMappingException("forName class[" + className + "] is error!", e);
        }
    }

    public static Class forName(String className, ClassLoader loader) {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (aliasClassMap.containsKey(className)) {
                return aliasClassMap.get(className);
            }
            throw new BeanMappingException("forName class[" + className + "] is error!", e);
        }
    }

    static {
        primitiveValueMap.put(Boolean.class, Boolean.FALSE);
        primitiveValueMap.put(Byte.class, (byte)0);
        primitiveValueMap.put(Character.class, Character.valueOf('\u0000'));
        primitiveValueMap.put(Short.class, (short)0);
        primitiveValueMap.put(Double.class, 0.0);
        primitiveValueMap.put(Float.class, Float.valueOf(0.0f));
        primitiveValueMap.put(Integer.class, 0);
        primitiveValueMap.put(Long.class, 0L);
        primitiveValueMap.put(Boolean.TYPE, Boolean.FALSE);
        primitiveValueMap.put(Byte.TYPE, (byte)0);
        primitiveValueMap.put(Character.TYPE, Character.valueOf('\u0000'));
        primitiveValueMap.put(Short.TYPE, (short)0);
        primitiveValueMap.put(Double.TYPE, 0.0);
        primitiveValueMap.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveValueMap.put(Integer.TYPE, 0);
        primitiveValueMap.put(Long.TYPE, 0L);
        aliasClassMap.put(alias_int_name, Integer.TYPE);
        aliasClassMap.put(alias_short_name, Short.TYPE);
        aliasClassMap.put(alias_long_name, Long.TYPE);
        aliasClassMap.put(alias_double_name, Double.TYPE);
        aliasClassMap.put(alias_char_name, Character.TYPE);
        aliasClassMap.put(alias_float_name, Float.TYPE);
        aliasClassMap.put(alias_byte_name, Byte.TYPE);
        aliasClassMap.put(alias_bool_name, Boolean.TYPE);
        aliasClassMap.put(alias_string_name, String.class);
        aliasClassMap.put(alias_list_name, ArrayList.class);
        aliasClassMap.put(alias_map_name, HashMap.class);
        aliasClassMap.put(alias_set_name, HashSet.class);
    }
}

