/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.config.parse;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.helper.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassAliasParse {
    private static final Logger logger = LoggerFactory.getLogger(ClassAliasParse.class);

    public static void parseAndRegister(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node aliasClassNode = nodeList.item(i);
            if (!"classAlias".equals(aliasClassNode.getNodeName())) continue;
            Node aliasNode = aliasClassNode.getAttributes().getNamedItem("alias");
            Node clazzNode = aliasClassNode.getAttributes().getNamedItem("class");
            if (aliasNode == null || clazzNode == null) {
                throw new BeanMappingException("alias or class is null , please check!");
            }
            String alias = aliasNode.getNodeValue();
            Class clazz = ReflectionHelper.forName(clazzNode.getNodeValue());
            ReflectionHelper.registerClassAlias(aliasNode.getNodeValue(), clazz);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("register class[" + clazz.toString() + "] to alias[" + alias + "]");
        }
    }
}

