/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.BeanMappingParam;
import com.agapple.mapping.core.config.BeanMappingBehavior;
import com.agapple.mapping.core.config.BeanMappingConfigHelper;
import com.agapple.mapping.core.config.BeanMappingField;
import com.agapple.mapping.core.config.BeanMappingObject;
import com.agapple.mapping.core.helper.BatchObjectHolder;
import com.agapple.mapping.core.introspect.BatchExecutor;
import com.agapple.mapping.core.introspect.FastPropertyGetExecutor;
import com.agapple.mapping.core.introspect.FastPropertySetExecutor;
import com.agapple.mapping.core.introspect.GetExecutor;
import com.agapple.mapping.core.introspect.MapSetExecutor;
import com.agapple.mapping.core.introspect.PropertyGetExecutor;
import com.agapple.mapping.core.introspect.PropertySetExecutor;
import com.agapple.mapping.core.introspect.SetExecutor;
import com.agapple.mapping.core.introspect.Uberspector;
import com.agapple.mapping.core.process.ValueProcessContext;
import com.agapple.mapping.core.process.ValueProcessInvocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanMappingExecutor {
    private static final Logger logger = LoggerFactory.getLogger(BeanMappingExecutor.class);

    public static void execute(BeanMappingParam param) {
        BeanMappingObject config = param.getConfig();
        boolean isDebug = config.getBehavior().isDebug();
        if (isDebug && logger.isDebugEnabled()) {
            logger.debug("====================== start mapping \n\t srcClass[" + param.getSrcRef().getClass().toString() + "] \n\t targetClass[" + param.getTargetRef().getClass().toString() + "]");
        }
        BatchObjectHolder holder = null;
        BatchExecutor getBatchExecutor = null;
        BatchExecutor setBatchExecutor = null;
        if (config.isBatch()) {
            getBatchExecutor = BeanMappingExecutor.getGetBatchExecutor(param, config);
            setBatchExecutor = BeanMappingExecutor.getSetBatchExecutor(param, config);
        }
        if (config.isBatch() && getBatchExecutor != null) {
            Object[] batchValues = getBatchExecutor.gets(param.getSrcRef());
            holder = new BatchObjectHolder(batchValues);
        }
        List<BeanMappingField> beanFields = config.getBeanFields();
        int size = beanFields.size();
        for (int i = 0; i < size; ++i) {
            BeanMappingField beanField = beanFields.get(i);
            if (beanField.isMapping()) {
                BeanMappingExecutor.doBeanMapping(param, beanField, holder);
                continue;
            }
            BeanMappingExecutor.doFieldMapping(param, beanField, holder);
        }
        if (config.isBatch() && setBatchExecutor != null && holder != null) {
            setBatchExecutor.sets(param.getTargetRef(), holder.getBatchValues());
        }
        if (isDebug && logger.isDebugEnabled()) {
            logger.debug("====================== end mapping");
        }
    }

    private static BatchExecutor getSetBatchExecutor(BeanMappingParam param, BeanMappingObject config) {
        BatchExecutor executor = config.getSetBatchExecutor();
        if (executor != null) {
            return executor;
        }
        if (!BeanMappingExecutor.canBatch(config.getBehavior())) {
            config.setBatch(false);
            return null;
        }
        ArrayList<String> targetFields = new ArrayList<String>();
        ArrayList<Class> targetArgs = new ArrayList<Class>();
        Class<?> locatorClass = param.getTargetRef().getClass();
        for (BeanMappingField beanField : config.getBeanFields()) {
            String targetField = beanField.getTargetField().getName();
            Class targetArg = beanField.getTargetField().getClazz();
            if (StringUtils.isEmpty((String)targetField) || targetArg == null) {
                return null;
            }
            Class selfLocatorClass = beanField.getTargetField().getLocatorClass();
            if (selfLocatorClass != null && selfLocatorClass != locatorClass) {
                config.setBatch(false);
                return null;
            }
            if (!BeanMappingExecutor.canBatch(beanField.getBehavior())) {
                config.setBatch(false);
                return null;
            }
            SetExecutor set = beanField.getSetExecutor();
            if (set != null && !(set instanceof FastPropertySetExecutor || set instanceof PropertySetExecutor)) {
                config.setBatch(false);
                return null;
            }
            targetFields.add(targetField);
            targetArgs.add(targetArg);
        }
        executor = Uberspector.getInstance().getBatchExecutor(locatorClass, targetFields.toArray(new String[targetFields.size()]), targetArgs.toArray(new Class[targetArgs.size()]));
        if (config.getBehavior().isDebug() && logger.isDebugEnabled()) {
            logger.debug("TargetClass[" + param.getTargetRef().getClass() + "]SetBatchExecutor is init");
        }
        config.setSetBatchExecutor(executor);
        return executor;
    }

    private static BatchExecutor getGetBatchExecutor(BeanMappingParam param, BeanMappingObject config) {
        BatchExecutor executor = config.getGetBatchExecutor();
        if (executor != null) {
            return executor;
        }
        if (!BeanMappingExecutor.canBatch(config.getBehavior())) {
            config.setBatch(false);
            return null;
        }
        ArrayList<String> srcFields = new ArrayList<String>();
        ArrayList<Class> srcArgs = new ArrayList<Class>();
        Class<?> locatorClass = param.getSrcRef().getClass();
        for (BeanMappingField beanField : config.getBeanFields()) {
            String srcField = beanField.getSrcField().getName();
            Class srcArg = beanField.getSrcField().getClazz();
            if (StringUtils.isEmpty((String)srcField) || srcArg == null) {
                return null;
            }
            Class selfLocatorClass = beanField.getSrcField().getLocatorClass();
            if (selfLocatorClass != null && selfLocatorClass != locatorClass) {
                config.setBatch(false);
            }
            if (!BeanMappingExecutor.canBatch(beanField.getBehavior())) {
                config.setBatch(false);
                return null;
            }
            GetExecutor get = beanField.getGetExecutor();
            if (get != null && !(get instanceof FastPropertyGetExecutor || get instanceof PropertyGetExecutor)) {
                config.setBatch(false);
                return null;
            }
            srcFields.add(srcField);
            srcArgs.add(srcArg);
        }
        executor = Uberspector.getInstance().getBatchExecutor(locatorClass, srcFields.toArray(new String[srcFields.size()]), srcArgs.toArray(new Class[srcArgs.size()]));
        if (config.getBehavior().isDebug() && logger.isDebugEnabled()) {
            logger.debug("SrcClass[" + param.getSrcRef().getClass() + "]GetBatchExecutor is init");
        }
        config.setGetBatchExecutor(executor);
        return executor;
    }

    private static void doFieldMapping(BeanMappingParam param, BeanMappingField beanField, BatchObjectHolder holder) {
        ValueProcessInvocation invocation;
        Object getResult;
        Class<?> getResultClass;
        SetExecutor setExecutor;
        ValueProcessContext valueContext = new ValueProcessContext(param, param.getConfig(), beanField, holder, param.getCustomValueContext());
        GetExecutor getExecutor = beanField.getGetExecutor();
        if (getExecutor == null && StringUtils.isNotEmpty((String)beanField.getSrcField().getName())) {
            Class<?> locatorClass = beanField.getSrcField().getLocatorClass();
            if (locatorClass == null) {
                locatorClass = param.getSrcRef().getClass();
                beanField.getSrcField().setLocatorClass(locatorClass);
            }
            getExecutor = Uberspector.getInstance().getGetExecutor(locatorClass, beanField.getSrcField().getName());
            beanField.setGetExecutor(getExecutor);
        }
        if ((setExecutor = beanField.getSetExecutor()) == null && StringUtils.isNotEmpty((String)beanField.getTargetField().getName())) {
            Class<?> locatorClass = beanField.getTargetField().getLocatorClass();
            if (locatorClass == null) {
                locatorClass = param.getTargetRef().getClass();
                beanField.getTargetField().setLocatorClass(locatorClass);
            }
            setExecutor = Uberspector.getInstance().getSetExecutor(locatorClass, beanField.getTargetField().getName(), beanField.getTargetField().getClazz());
            beanField.setSetExecutor(setExecutor);
        }
        Class<?> clazz = getResultClass = (getResult = (invocation = new ValueProcessInvocation(getExecutor, setExecutor, valueContext, param.getProcesses())).getInitialValue()) != null ? getResult.getClass() : null;
        if (getExecutor != null && beanField.getSrcField().getClazz() == null) {
            beanField.getSrcField().setClazz(Uberspector.getInstance().getGetClass(getExecutor, param.getSrcRef().getClass(), getResultClass));
        }
        if (setExecutor != null && beanField.getTargetField().getClazz() == null) {
            beanField.getTargetField().setClazz(Uberspector.getInstance().getSetClass(setExecutor, param.getTargetRef().getClass(), getResultClass));
        }
        invocation.proceed(getResult);
    }

    private static void doBeanMapping(BeanMappingParam param, BeanMappingField beanField, BatchObjectHolder holder) {
        ValueProcessInvocation invocation;
        Object srcRef;
        Class<?> getResultClass;
        SetExecutor setExecutor;
        ValueProcessContext valueContext = new ValueProcessContext(param, param.getConfig(), beanField, holder, param.getCustomValueContext());
        GetExecutor getExecutor = beanField.getGetExecutor();
        if (getExecutor == null && StringUtils.isNotEmpty((String)beanField.getSrcField().getName())) {
            Class<?> locatorClass = beanField.getSrcField().getLocatorClass();
            if (locatorClass == null) {
                locatorClass = param.getSrcRef().getClass();
                beanField.getSrcField().setLocatorClass(locatorClass);
            }
            getExecutor = Uberspector.getInstance().getGetExecutor(locatorClass, beanField.getSrcField().getName());
            beanField.setGetExecutor(getExecutor);
        }
        if ((setExecutor = beanField.getSetExecutor()) == null && StringUtils.isNotEmpty((String)beanField.getTargetField().getName())) {
            Class<?> locatorClass = beanField.getTargetField().getLocatorClass();
            if (locatorClass == null) {
                locatorClass = param.getTargetRef().getClass();
                beanField.getTargetField().setLocatorClass(locatorClass);
            }
            setExecutor = Uberspector.getInstance().getSetExecutor(locatorClass, beanField.getTargetField().getName(), beanField.getTargetField().getClazz());
            beanField.setSetExecutor(setExecutor);
        }
        Class<?> clazz = getResultClass = (srcRef = (invocation = new ValueProcessInvocation(getExecutor, setExecutor, valueContext, param.getProcesses())).getInitialValue()) != null ? srcRef.getClass() : null;
        if (getExecutor != null && beanField.getSrcField().getClazz() == null) {
            beanField.getSrcField().setClazz(Uberspector.getInstance().getGetClass(getExecutor, param.getSrcRef().getClass(), getResultClass));
        }
        if (setExecutor != null && beanField.getTargetField().getClazz() == null) {
            beanField.getTargetField().setClazz(Uberspector.getInstance().getSetClass(setExecutor, param.getTargetRef().getClass(), getResultClass));
            if (setExecutor instanceof MapSetExecutor) {
                beanField.getTargetField().setClazz(HashMap.class);
            }
        }
        Object value = invocation.proceed(srcRef);
        if (srcRef == null && value == null) {
            return;
        }
        if (beanField.getSrcField().getClazz() == null || beanField.getTargetField().getClazz() == null) {
            throw new BeanMappingException("srcClass or targetClass is null , " + beanField.toString());
        }
        BeanMappingObject object = beanField.getNestObject();
        if (object == null) {
            object = StringUtils.isNotEmpty((String)beanField.getNestName()) ? BeanMappingConfigHelper.getInstance().getBeanMappingObject(beanField.getNestName()) : BeanMappingConfigHelper.getInstance().getBeanMappingObject(beanField.getSrcField().getClazz(), beanField.getTargetField().getClazz());
            beanField.setNestObject(object);
        }
        if (object == null) {
            throw new BeanMappingException("no bean mapping config for " + beanField.toString());
        }
        BeanMappingParam newParam = new BeanMappingParam();
        newParam.setTargetRef(value);
        newParam.setSrcRef(srcRef);
        newParam.setConfig(object);
        newParam.setProcesses(param.getProcesses());
        BeanMappingExecutor.execute(newParam);
    }

    private static boolean canBatch(BeanMappingBehavior behavior) {
        return behavior.isMappingEmptyStrings() && behavior.isMappingNullValue();
    }
}

