/*
 * Decompiled with CFR 0.152.
 */
package com.mars.common.util;

import com.mars.common.util.MarsConfiguration;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class MarsAddressUtil {
    private static String ip;

    public static String getLocalIp() throws Exception {
        if (ip == null) {
            ip = MarsAddressUtil.getLocalHostLANAddress().getHostAddress();
        }
        return ip;
    }

    public static int getPort() {
        return MarsConfiguration.getConfig().port();
    }

    public static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = MarsAddressUtil.getLocalHost();
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    private static InetAddress getLocalHost() throws Exception {
        InetAddress candidateAddress = null;
        Enumeration<NetworkInterface> iFaces = NetworkInterface.getNetworkInterfaces();
        while (iFaces.hasMoreElements()) {
            NetworkInterface iFace = iFaces.nextElement();
            Enumeration<InetAddress> enumeration = iFace.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (inetAddress.isLoopbackAddress()) continue;
                if (inetAddress.isSiteLocalAddress()) {
                    return inetAddress;
                }
                if (candidateAddress != null) continue;
                candidateAddress = inetAddress;
            }
        }
        return candidateAddress;
    }
}

