/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.repository;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.github.xiaoymin.knife4j.aggre.core.common.RouteUtils;
import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.github.xiaoymin.knife4j.aggre.core.pojo.CommonRoute;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import com.github.xiaoymin.knife4j.aggre.eureka.EurekaApplication;
import com.github.xiaoymin.knife4j.aggre.eureka.EurekaInstance;
import com.github.xiaoymin.knife4j.aggre.eureka.EurekaRoute;
import com.github.xiaoymin.knife4j.aggre.repository.AbstractRepository;
import com.github.xiaoymin.knife4j.aggre.spring.support.EurekaSetting;
import com.github.xiaoymin.knife4j.core.util.CollectionUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaRepository
extends AbstractRepository {
    private volatile boolean stop = false;
    private Thread thread;
    Logger logger = LoggerFactory.getLogger(EurekaRepository.class);
    private EurekaSetting eurekaSetting;

    public EurekaRepository(EurekaSetting eurekaSetting) {
        this.eurekaSetting = eurekaSetting;
        if (eurekaSetting != null && CollectionUtils.isNotEmpty(eurekaSetting.getRoutes())) {
            if (StrUtil.isBlank((CharSequence)eurekaSetting.getServiceUrl())) {
                throw new RuntimeException("Eureka ServiceUrl can't empty!!!");
            }
            this.initEurekaApps(eurekaSetting);
        }
    }

    private List<EurekaApplication> getApplications(EurekaSetting eurekaSetting) {
        List eurekaApps = null;
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(eurekaSetting.getServiceUrl());
        if (!StrUtil.endWith((CharSequence)eurekaSetting.getServiceUrl(), (CharSequence)"/")) {
            requestUrl.append("/");
        }
        requestUrl.append("apps");
        String eurekaMetaApi = requestUrl.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Eureka meta api:{}", (Object)eurekaMetaApi);
        }
        HttpGet get = new HttpGet(eurekaMetaApi);
        get.addHeader("Accept", "application/json");
        try {
            CloseableHttpResponse response;
            if (eurekaSetting.getServiceAuth() != null && eurekaSetting.getServiceAuth().isEnable()) {
                get.addHeader("Authorization", RouteUtils.authorize(eurekaSetting.getServiceAuth().getUsername(), eurekaSetting.getServiceAuth().getPassword()));
            }
            if ((response = this.getClient().execute((HttpUriRequest)get)) != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Eureka Response code:{}", (Object)statusCode);
                }
                if (statusCode == 200) {
                    JsonElement application;
                    JsonElement applications;
                    JsonElement jsonElement;
                    String content = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Eureka Response Content:{}", (Object)content);
                    }
                    if (StrUtil.isNotBlank((CharSequence)content) && (jsonElement = JsonParser.parseString((String)content)) != null && jsonElement.isJsonObject() && (applications = jsonElement.getAsJsonObject().get("applications")) != null && applications.isJsonObject() && (application = applications.getAsJsonObject().get("application")) != null) {
                        Type type = new TypeToken<List<EurekaApplication>>(){}.getType();
                        eurekaApps = (List)new Gson().fromJson(application, type);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("load Register Metadata from Eureka Error,message:" + e.getMessage(), (Throwable)e);
        }
        return eurekaApps;
    }

    private Map<String, SwaggerRoute> applySwaggerRoutes(List<EurekaApplication> eurekaApps) {
        HashMap<String, SwaggerRoute> swaggerRouteMap = new HashMap<String, SwaggerRoute>();
        List serviceNames = this.eurekaSetting.getRoutes().stream().map(EurekaRoute::getServiceName).map(String::toLowerCase).collect(Collectors.toList());
        for (EurekaApplication eurekaApplication : eurekaApps) {
            Optional<EurekaRoute> eurekaRouteOptional;
            Optional<EurekaInstance> instanceOptional;
            if (!serviceNames.contains(eurekaApplication.getName().toLowerCase()) || !CollectionUtils.isNotEmpty(eurekaApplication.getInstance()) || !(instanceOptional = eurekaApplication.getInstance().stream().filter(eurekaInstance -> StrUtil.equalsIgnoreCase((CharSequence)eurekaInstance.getStatus(), (CharSequence)"up")).findFirst()).isPresent() || !(eurekaRouteOptional = this.eurekaSetting.getRoutes().stream().filter(eurekaRoute -> StrUtil.equalsIgnoreCase((CharSequence)eurekaRoute.getServiceName(), (CharSequence)eurekaApplication.getName())).findFirst()).isPresent()) continue;
            EurekaRoute eurekaRoute2 = eurekaRouteOptional.get();
            EurekaInstance eurekaInstance2 = instanceOptional.get();
            if (eurekaRoute2.getRouteAuth() == null || !eurekaRoute2.getRouteAuth().isEnable()) {
                eurekaRoute2.setRouteAuth(this.eurekaSetting.getRouteAuth());
            }
            swaggerRouteMap.put(eurekaRoute2.pkId(), new SwaggerRoute(eurekaRoute2, eurekaInstance2));
        }
        return swaggerRouteMap;
    }

    private void initEurekaApps(EurekaSetting eurekaSetting) {
        Map<String, SwaggerRoute> swaggerRouteMap;
        List<EurekaApplication> eurekaApps = this.getApplications(eurekaSetting);
        if (CollectionUtils.isNotEmpty(eurekaApps) && CollectionUtils.isNotEmpty(swaggerRouteMap = this.applySwaggerRoutes(eurekaApps))) {
            for (Map.Entry<String, SwaggerRoute> swaggerRouteEntry : swaggerRouteMap.entrySet()) {
                this.routeMap.put(swaggerRouteEntry.getKey(), swaggerRouteEntry.getValue());
            }
        }
    }

    @Override
    public BasicAuth getAuth(String header) {
        BasicAuth basicAuth = null;
        if (this.eurekaSetting != null && CollectionUtils.isNotEmpty(this.eurekaSetting.getRoutes())) {
            if (this.eurekaSetting.getRouteAuth() != null && this.eurekaSetting.getRouteAuth().isEnable()) {
                basicAuth = this.eurekaSetting.getRouteAuth();
                BasicAuth routeBasicAuth = this.getAuthByRoute(header, this.eurekaSetting.getRoutes());
                if (routeBasicAuth != null) {
                    basicAuth = routeBasicAuth;
                }
            } else {
                basicAuth = this.getAuthByRoute(header, this.eurekaSetting.getRoutes());
            }
        }
        return basicAuth;
    }

    public EurekaSetting getEurekaSetting() {
        return this.eurekaSetting;
    }

    @Override
    public void start() {
        this.logger.info("start Eureka heartbeat Holder thread.");
        this.thread = new Thread(() -> {
            while (!this.stop) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Knife4jAggregation Eureka heartbeat working...");
                    }
                    if (this.eurekaSetting != null && CollectionUtils.isNotEmpty(this.eurekaSetting.getRoutes())) {
                        if (StrUtil.isBlank((CharSequence)this.eurekaSetting.getServiceUrl())) {
                            throw new RuntimeException("Eureka ServiceUrl can't empty!!!");
                        }
                        List<EurekaApplication> eurekaApps = this.getApplications(this.eurekaSetting);
                        if (CollectionUtils.isNotEmpty(eurekaApps)) {
                            Map<String, SwaggerRoute> swaggerRouteMap = this.applySwaggerRoutes(eurekaApps);
                            if (CollectionUtils.isNotEmpty(swaggerRouteMap)) {
                                Set oldRouteKeys = this.routeMap.keySet();
                                for (String string : oldRouteKeys) {
                                    if (swaggerRouteMap.containsKey(string)) continue;
                                    this.routeMap.remove(string);
                                }
                                for (Map.Entry entry : swaggerRouteMap.entrySet()) {
                                    this.routeMap.put((String)entry.getKey(), (SwaggerRoute)entry.getValue());
                                }
                            } else {
                                this.routeMap.clear();
                            }
                        } else {
                            this.routeMap.clear();
                        }
                        List<String> settingRouteIds = this.eurekaSetting.getRoutes().stream().map(CommonRoute::pkId).collect(Collectors.toList());
                        this.heartRepeatClear(settingRouteIds);
                    }
                }
                catch (Exception e) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
                ThreadUtil.sleep((Number)HEART_BEAT_DURATION);
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void close() {
        this.logger.info("stop Eureka heartbeat Holder thread.");
        this.stop = true;
        if (this.thread != null) {
            ThreadUtil.interrupt((Thread)this.thread, (boolean)true);
        }
    }
}

