/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.core.executor;

import cn.hutool.core.collection.CollectionUtil;
import com.github.xiaoymin.knife4j.aggre.core.RouteExecutor;
import com.github.xiaoymin.knife4j.aggre.core.RouteRequestContext;
import com.github.xiaoymin.knife4j.aggre.core.RouteResponse;
import com.github.xiaoymin.knife4j.aggre.core.executor.ApacheClientResponse;
import com.github.xiaoymin.knife4j.aggre.core.executor.DefaultClientResponse;
import com.github.xiaoymin.knife4j.aggre.core.ext.PoolingConnectionManager;
import com.github.xiaoymin.knife4j.aggre.core.pojo.HeaderWrapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.Part;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheClientExecutor
extends PoolingConnectionManager
implements RouteExecutor {
    Logger logger = LoggerFactory.getLogger(ApacheClientExecutor.class);

    private HttpUriRequest buildRequest(RouteRequestContext routeContext) {
        RequestBuilder builder = RequestBuilder.create((String)routeContext.getMethod());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ApacheClient Uri:{}", (Object)routeContext.getUrl());
        }
        builder.setUri(routeContext.getUrl());
        if (CollectionUtil.isNotEmpty(routeContext.getHeaders())) {
            for (HeaderWrapper headerWrapper : routeContext.getHeaders()) {
                builder.addHeader(headerWrapper.getName(), headerWrapper.getValue());
            }
        }
        if (CollectionUtil.isNotEmpty(routeContext.getParams())) {
            for (Map.Entry entry : routeContext.getParams().entrySet()) {
                builder.addParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (routeContext.getRequestContent() != null) {
            if (CollectionUtil.isNotEmpty(routeContext.getParts())) {
                MultipartEntityBuilder partFileBuilder = MultipartEntityBuilder.create();
                partFileBuilder.setCharset(StandardCharsets.UTF_8);
                partFileBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                Header header = builder.getFirstHeader("content-type");
                if (header != null) {
                    partFileBuilder.setContentType(ContentType.parse((String)header.getValue()));
                }
                for (Part part : routeContext.getParts()) {
                    try {
                        partFileBuilder.addBinaryBody(part.getName(), part.getInputStream(), ContentType.MULTIPART_FORM_DATA, part.getSubmittedFileName());
                    }
                    catch (IOException e) {
                        this.logger.warn("add part file error,message:" + e.getMessage());
                    }
                }
                builder.setEntity(partFileBuilder.build());
            } else {
                BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
                basicHttpEntity.setContent(routeContext.getRequestContent());
                builder.setEntity((HttpEntity)basicHttpEntity);
            }
        }
        builder.setConfig(this.getRequestConfig());
        return builder.build();
    }

    @Override
    public RouteResponse executor(RouteRequestContext routeContext) {
        RouteResponse routeResponse = null;
        try {
            CloseableHttpResponse closeableHttpResponse = this.getClient().execute(this.buildRequest(routeContext));
            routeResponse = new ApacheClientResponse((HttpResponse)closeableHttpResponse);
        }
        catch (Exception e) {
            this.logger.error("Executor Failed,message:" + e.getMessage(), (Throwable)e);
            routeResponse = e instanceof HttpHostConnectException ? new DefaultClientResponse(routeContext.getOriginalUri(), e.getMessage(), 504) : new DefaultClientResponse(routeContext.getOriginalUri(), e.getMessage());
        }
        return routeResponse;
    }
}

