/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaour.api_scanner.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SapiJsonUtil {
    private static final String OBJ_START = "{";
    private static final String OBJ_END = "}";
    private static final String ARRAY_START = "[";
    private static final String ARRAY_END = "]";
    private static final String KEY_SPLIT = ":";
    private static final String ELEM_SPLIT = ",";
    private static String dateFormat = "yyyy-MM-dd HH:mm:ss";

    public static void setDateFormat(String dateFormat) {
        SapiJsonUtil.dateFormat = dateFormat;
    }

    public static String dateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    private static StringBuffer objStart() {
        return new StringBuffer(OBJ_START);
    }

    private static String objEnd(StringBuffer sb) {
        if (sb.lastIndexOf(ELEM_SPLIT) != -1) {
            sb.deleteCharAt(sb.lastIndexOf(ELEM_SPLIT));
        }
        return sb.append(OBJ_END).toString();
    }

    private static StringBuffer arrayStart() {
        return new StringBuffer(ARRAY_START);
    }

    private static String arrayEnd(StringBuffer sb) {
        if (sb.lastIndexOf(ELEM_SPLIT) != -1) {
            sb.deleteCharAt(sb.lastIndexOf(ELEM_SPLIT));
        }
        return sb.append(ARRAY_END).toString();
    }

    private static String appendKey(String key) {
        StringBuffer sb = new StringBuffer();
        return sb.append("\"").append(key).append("\"").append(KEY_SPLIT).toString();
    }

    private static String appendValue(Object obj) {
        if (obj == null) {
            return null;
        }
        StringBuffer sb = SapiJsonUtil.objStart();
        Class<?> oClass = obj.getClass();
        Field[] fields = oClass.getDeclaredFields();
        if (fields.length <= 0) {
            sb.append("null");
        } else {
            for (Field field : fields) {
                field.setAccessible(true);
                String fieldName = field.getName();
                char[] ch = fieldName.toCharArray();
                if (ch[0] >= 'a' && ch[0] <= 'z') {
                    ch[0] = (char)(ch[0] - 32);
                }
                String str = "get" + new String(ch);
                Method method = null;
                try {
                    method = oClass.getMethod(str, null);
                }
                catch (Exception e1) {
                    throw new RuntimeException("\u6ca1\u6709\u65b9\u6cd5:" + str + "()  " + e1.getLocalizedMessage());
                }
                if (method == null || !Modifier.isPublic(method.getModifiers())) continue;
                Object fieldValue = null;
                try {
                    fieldValue = field.get(obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sb.append(SapiJsonUtil.appendKey(fieldName));
                sb.append(SapiJsonUtil.objectJsonUtil(fieldValue));
                sb.append(ELEM_SPLIT);
            }
        }
        return SapiJsonUtil.objEnd(sb);
    }

    public static String collectionJsonUtil(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        StringBuffer sb = SapiJsonUtil.arrayStart();
        for (Object object : collection) {
            sb.append(SapiJsonUtil.objectJsonUtil(object));
            sb.append(ELEM_SPLIT);
        }
        return SapiJsonUtil.arrayEnd(sb);
    }

    public static String collectionJsonUtil(Collection<?> collection, boolean boo) {
        String collectionJsonUtil = SapiJsonUtil.collectionJsonUtil(collection);
        if (boo && collectionJsonUtil != null) {
            return SapiJsonUtil.jsonFormat(collectionJsonUtil);
        }
        return collectionJsonUtil;
    }

    public static String arrayJsonUtil(Object[] oobj) {
        if (oobj == null) {
            return null;
        }
        StringBuffer sb = SapiJsonUtil.arrayStart();
        for (Object object : oobj) {
            sb.append(SapiJsonUtil.objectJsonUtil(object));
            sb.append(ELEM_SPLIT);
        }
        return SapiJsonUtil.arrayEnd(sb);
    }

    public static String arrayJsonUtil(Object[] oobj, boolean boo) {
        String arrayJsonUtil = SapiJsonUtil.arrayJsonUtil(oobj);
        if (boo && arrayJsonUtil != null) {
            return SapiJsonUtil.jsonFormat(arrayJsonUtil);
        }
        return arrayJsonUtil;
    }

    public static String objectJsonUtil(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> oClass = obj.getClass();
        StringBuffer sb = new StringBuffer();
        if (String.class.isAssignableFrom(oClass)) {
            String string = SapiJsonUtil.charSequence(obj);
            sb.append("\"").append(string).append("\"");
        } else if (Map.class.isAssignableFrom(oClass)) {
            sb.append(SapiJsonUtil.mapJsonUtil((Map)obj));
        } else if (Collection.class.isAssignableFrom(oClass)) {
            sb.append(SapiJsonUtil.collectionJsonUtil((Collection)obj));
        } else if (Integer.class.isAssignableFrom(oClass) || Double.class.isAssignableFrom(oClass) || Boolean.class.isAssignableFrom(oClass) || Long.class.isAssignableFrom(oClass) || Byte.class.isAssignableFrom(oClass) || Short.class.isAssignableFrom(oClass) || Float.class.isAssignableFrom(oClass)) {
            sb.append(obj);
        } else if (Character.class.isAssignableFrom(oClass)) {
            String string = SapiJsonUtil.charSequence(obj);
            sb.append("\"").append(string).append("\"");
        } else if (oClass.isArray()) {
            sb.append(SapiJsonUtil.arrayJsonUtil((Object[])obj));
        } else if (Date.class.isAssignableFrom(oClass)) {
            sb.append("\"").append(SapiJsonUtil.dateToString((Date)obj)).append("\"");
        } else {
            sb.append(SapiJsonUtil.appendValue(obj));
        }
        return sb.toString();
    }

    private static String charSequence(Object obj) {
        String string = null;
        if (obj instanceof Character) {
            Character c = (Character)obj;
            string = String.valueOf(c);
        } else {
            string = (String)obj;
        }
        StringBuffer sb = new StringBuffer();
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String objectJsonUtil(Object obj, boolean boo) {
        String objectJsonUtil = SapiJsonUtil.objectJsonUtil(obj);
        if (boo && objectJsonUtil != null) {
            return SapiJsonUtil.jsonFormat(objectJsonUtil);
        }
        return objectJsonUtil;
    }

    public static String mapJsonUtil(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        StringBuffer sb = SapiJsonUtil.objStart();
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            sb.append(SapiJsonUtil.appendKey(entry.getKey()));
            sb.append(SapiJsonUtil.objectJsonUtil(entry.getValue()));
            sb.append(ELEM_SPLIT);
        }
        return SapiJsonUtil.objEnd(sb);
    }

    public static String mapJsonUtil(Map<String, Object> map, boolean boo) {
        String mapJsonUtil = SapiJsonUtil.mapJsonUtil(map);
        if (boo && mapJsonUtil != null) {
            return SapiJsonUtil.jsonFormat(mapJsonUtil);
        }
        return mapJsonUtil;
    }

    public static String jsonFormat(String json) {
        StringBuffer sb = new StringBuffer();
        int tabNum = 0;
        block5: for (int index = 0; index < json.length(); ++index) {
            char c = json.charAt(index);
            if (tabNum > 0 && '\n' == sb.charAt(sb.length() - 1)) {
                sb.append(SapiJsonUtil.getLevelStr(tabNum));
            }
            switch (c) {
                case '[': 
                case '{': {
                    sb.append(c + "\n");
                    ++tabNum;
                    continue block5;
                }
                case ',': {
                    sb.append(c + "\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    sb.append("\n");
                    sb.append(SapiJsonUtil.getLevelStr(--tabNum));
                    sb.append(c);
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String getLevelStr(int tabNum) {
        StringBuffer sb = new StringBuffer();
        for (int index = 0; index < tabNum; ++index) {
            sb.append("\t");
        }
        return sb.toString();
    }

    public static List<Map<String, Object>> jsonToArray(String jsonStr) {
        String[] jsonList;
        jsonStr = SapiJsonUtil.trimFirstAndLastChar(jsonStr, ARRAY_START);
        jsonStr = SapiJsonUtil.trimFirstAndLastChar(jsonStr, ARRAY_END);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        for (String s : jsonList = jsonStr.split(",\\{")) {
            dataList.add(SapiJsonUtil.stringToMap(s));
        }
        return dataList;
    }

    private static Map<String, Object> stringToMap(String jsonObj) {
        String[] keyValueArray;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (jsonObj.contains("[{")) {
            jsonObj = jsonObj.replaceAll("\\{", "").replaceAll("\\}", "");
        }
        for (String kv : keyValueArray = jsonObj.split(",\"")) {
            String[] kvArray = kv.split("\":");
            map.put(kvArray[0].replaceAll("\"", ""), kvArray[1].replaceAll("\"", ""));
        }
        return map;
    }

    public static String trimFirstAndLastChar(String source, String element) {
        boolean beginIndexFlag = true;
        boolean endIndexFlag = true;
        do {
            int beginIndex = source.indexOf(element) == 0 ? 1 : 0;
            int endIndex = source.lastIndexOf(element) + 1 == source.length() ? source.lastIndexOf(element) : source.length();
            source = source.substring(beginIndex, endIndex);
            beginIndexFlag = source.indexOf(element) == 0;
            boolean bl = endIndexFlag = source.lastIndexOf(element) + 1 == source.length();
        } while (beginIndexFlag || endIndexFlag);
        return source;
    }

    public <T> List<List<T>> splitList(List<T> list, int pageSize) {
        int listSize = list.size();
        int page = (listSize + (pageSize - 1)) / pageSize;
        ArrayList<List<T>> listArray = new ArrayList<List<T>>();
        for (int i = 0; i < page; ++i) {
            ArrayList<T> subList = new ArrayList<T>();
            for (int j = 0; j < listSize; ++j) {
                int pageIndex = (j + 1 + (pageSize - 1)) / pageSize;
                if (pageIndex == i + 1) {
                    subList.add(list.get(j));
                }
                if (j + 1 == (j + 1) * pageSize) break;
            }
            listArray.add(subList);
        }
        return listArray;
    }
}

