/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaour.api_scanner.servlet;

import com.github.xiaour.api_scanner.config.ApiServerAutoConfigure;
import com.github.xiaour.api_scanner.config.SapiFactoryAutoConfigure;
import com.github.xiaour.api_scanner.config.SapiGroupManager;
import com.github.xiaour.api_scanner.dto.ApiInfo;
import com.github.xiaour.api_scanner.util.SapiJsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.el.MethodNotFoundException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="ApiJsonServlet", urlPatterns={"/sapidata/*"})
public class ApiJsonServlet
extends HttpServlet {
    private static Integer pageSize = 10;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json;charset=utf-8");
        resp.setCharacterEncoding("UTF-8");
        String url = req.getRequestURI();
        if (!ApiServerAutoConfigure.apiRouter.contains(url)) {
            throw new MethodNotFoundException();
        }
        if (url.equals(ApiServerAutoConfigure.getContextPath() + "/sapidata/apiList")) {
            this.getApiList(req, resp);
        }
        if (url.equals(ApiServerAutoConfigure.getContextPath() + "/sapidata/group")) {
            this.getApiGroup(req, resp);
        }
    }

    private void getApiList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int totalPage = -1;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (request.getParameter("pageNum") != null) {
            Integer pageNum = Integer.parseInt(request.getParameter("pageNum"));
            totalPage = ApiJsonServlet.getPageCount(pageSize, SapiFactoryAutoConfigure.simpleApiList.size());
            map.put("apiList", ApiJsonServlet.getListByPage(pageSize, pageNum, SapiFactoryAutoConfigure.simpleApiList));
        } else {
            map.put("apiList", SapiFactoryAutoConfigure.simpleApiList);
        }
        map.put("totalPage", totalPage);
        PrintWriter out = response.getWriter();
        out.write(SapiJsonUtil.mapJsonUtil(map));
        out.close();
    }

    private void getApiGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap map = new HashMap();
        Set<String> group = SapiGroupManager.getSapiGroup();
        List<ApiInfo> apiList = SapiFactoryAutoConfigure.simpleApiList;
        for (String title : group) {
            HashMap<String, ApiInfo> childMap = new HashMap<String, ApiInfo>();
            for (ApiInfo apiInfo : apiList) {
                if (!apiInfo.getGroupTitle().equals(title)) continue;
                childMap.put(apiInfo.getUrl(), apiInfo);
            }
            map.put(title, childMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("total", apiList.size());
        resultMap.put("totalModule", group.size());
        resultMap.put("data", map);
        PrintWriter out = response.getWriter();
        out.write(SapiJsonUtil.mapJsonUtil(resultMap));
        out.close();
    }

    public static List<ApiInfo> getListByPage(Integer pageSize, Integer pageNum, List<ApiInfo> list) {
        int size = list.size();
        int pageCount = ApiJsonServlet.getPageCount(pageSize, size);
        int fromIndex = pageSize * (pageNum - 1);
        int toIndex = fromIndex + pageSize;
        if (toIndex >= size) {
            toIndex = size;
        }
        if (pageNum > pageCount + 1) {
            fromIndex = 0;
            toIndex = 0;
        }
        if (fromIndex > size) {
            ApiJsonServlet.getListByPage(pageSize, pageNum - 1, list);
        }
        return list.subList(fromIndex, toIndex);
    }

    public static Integer getPageCount(Integer pageSize, Integer total) {
        total = total <= 0 ? 1 : total;
        int pageCount = pageSize % total > 0 ? total / pageSize + 1 : total / pageSize;
        return pageCount;
    }
}

