/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaour.api_scanner.logging;

import com.github.xiaour.api_scanner.logging.Log;

public class NoLoggingImpl
implements Log {
    private int infoCount;
    private int errorCount;
    private int warnCount;
    private int debugCount;
    private String loggerName;
    private boolean debugEnable = false;
    private boolean infoEnable = true;
    private boolean warnEnable = true;
    private boolean errorEnable = true;

    public NoLoggingImpl(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnable;
    }

    @Override
    public void error(String s, Throwable e) {
        if (!this.errorEnable) {
            return;
        }
        this.error(s);
        if (e != null) {
            e.printStackTrace();
        }
    }

    @Override
    public void error(String s) {
        ++this.errorCount;
        if (s != null) {
            // empty if block
        }
    }

    @Override
    public void debug(String s) {
        ++this.debugCount;
    }

    @Override
    public void debug(String s, Throwable e) {
        ++this.debugCount;
    }

    @Override
    public void warn(String s) {
        ++this.warnCount;
    }

    @Override
    public void warn(String s, Throwable e) {
        ++this.warnCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarnCount() {
        return this.warnCount;
    }

    @Override
    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
        this.debugCount = 0;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoEnable;
    }

    @Override
    public void info(String s) {
        ++this.infoCount;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.warnEnable;
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    @Override
    public int getDebugCount() {
        return this.debugCount;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.errorEnable;
    }

    public void setErrorEnabled(boolean value) {
        this.errorEnable = value;
    }
}

