/*
 *
 * Copyright 2020 Wei-Ming Wu
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.github.wnameless.json.base;

/**
 * 
 * {@link JsonValueCore} extends {@link JsonValueBase} and alters the returning values of
 * {@link #asObject()}, {@link #asArray()} and {@link #asValue()} from immutable "Base" version to
 * mutable "Core" version.<br>
 * <br>
 * It also extends {@link JsonSource} which allows it returns the JSON implementation object of this
 * wrapper.
 * 
 * @author Wei-Ming Wu
 *
 * @param <JVC> the type of a JSON implementation wrapper
 */
public interface JsonValueCore<JVC extends JsonValueCore<JVC>>
    extends JsonValueBase<JVC>, JsonSource {

  @Override
  JsonObjectCore<JVC> asObject();

  @Override
  JsonArrayCore<JVC> asArray();

  @Override
  JsonValueCore<JVC> asValue();

}
