/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.PaintOrder;
import com.github.weisj.jsvg.attributes.VectorEffect;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.text.AbstractGlyphRun;
import com.github.weisj.jsvg.nodes.text.EmojiGlyph;
import com.github.weisj.jsvg.nodes.text.Glyph;
import com.github.weisj.jsvg.nodes.text.GlyphCursor;
import com.github.weisj.jsvg.nodes.text.GlyphRun;
import com.github.weisj.jsvg.nodes.text.StringTextSegment;
import com.github.weisj.jsvg.nodes.text.TextOutput;
import com.github.weisj.jsvg.renderer.FontRenderContext;
import com.github.weisj.jsvg.renderer.Output;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.renderer.ShapeRenderer;
import com.github.weisj.jsvg.util.ShapeUtil;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class GlyphRenderer {
    private static final boolean DEBUG = false;

    private GlyphRenderer() {
    }

    static void prepareGlyphRun(@NotNull StringTextSegment segment, @NotNull GlyphCursor cursor, @NotNull SVGFont font, @NotNull RenderContext context, @NotNull TextOutput textOutput) {
        GlyphRun glyphRun = GlyphRenderer.layoutGlyphRun(segment, cursor, font, context, textOutput);
        Rectangle2D bounds = glyphRun.shape().getBounds2D();
        if (Length.isUnspecified((float)cursor.completeGlyphRunBounds.getX())) {
            cursor.completeGlyphRunBounds.setRect(bounds);
        } else {
            Rectangle2D.union(cursor.completeGlyphRunBounds, bounds, cursor.completeGlyphRunBounds);
        }
        segment.currentGlyphRun = glyphRun;
        segment.currentRenderContext = context;
    }

    static void renderGlyphRun(@NotNull Output output, @NotNull PaintOrder paintOrder, @NotNull Set<VectorEffect> vectorEffects, @NotNull StringTextSegment segment, @NotNull Rectangle2D completeGlyphRunBounds) {
        RenderContext context = segment.currentRenderContext;
        assert (context != null);
        GlyphRun glyphRun = segment.currentGlyphRun;
        assert (glyphRun != null);
        Stroke stroke = context.stroke(1.0f);
        ShapeRenderer.renderWithPaintOrder(output, true, paintOrder, new ShapeRenderer.ShapePaintContext(context, vectorEffects, stroke, null), new ShapeRenderer.PaintShape((Shape)glyphRun.shape(), completeGlyphRunBounds), null);
        SVGFont font = context.font();
        Output.SafeState safeState = output.safeState();
        for (AbstractGlyphRun.PaintableEmoji emoji : glyphRun.emojis()) {
            emoji.render(output, font);
            safeState.restore();
        }
        segment.currentRenderContext = null;
        segment.currentGlyphRun = null;
    }

    @NotNull
    static GlyphRun layoutGlyphRun(@NotNull StringTextSegment segment, @NotNull GlyphCursor cursor, @NotNull SVGFont font, @NotNull RenderContext context, @NotNull TextOutput textOutput) {
        MeasureContext measure = context.measureContext();
        FontRenderContext fontRenderContext = context.fontRenderContext();
        float letterSpacing = fontRenderContext.letterSpacing().resolve(measure);
        Path2D.Float glyphPath = new Path2D.Float();
        List<AbstractGlyphRun.PaintableEmoji> emojis = null;
        boolean isLastSegment = segment.isLastSegmentInParent();
        boolean shouldSkipLastSpacing = isLastSegment && cursor.advancement().shouldSkipLastSpacing();
        textOutput.glyphRunBreak();
        List<String> codepoints = segment.codepoints();
        int count = codepoints.size();
        for (int i = 0; i < count; ++i) {
            boolean skipSpacing;
            String codepoint = codepoints.get(i);
            boolean lastCodepoint = i == count - 1;
            Glyph glyph = font.codepointGlyph(codepoint);
            if (i > 0 && !cursor.isCurrentGlyphAutoLayout()) {
                textOutput.glyphRunBreak();
            }
            AffineTransform glyphTransform = cursor.advance(measure, glyph);
            boolean bl = skipSpacing = lastCodepoint && shouldSkipLastSpacing;
            if (!skipSpacing) {
                cursor.advanceSpacing(letterSpacing);
            }
            if (glyphTransform == null) break;
            if (glyph.isRendered()) {
                float baselineOffset = GlyphRenderer.computeBaselineOffset(font, fontRenderContext);
                glyphTransform.translate(0.0, -baselineOffset);
                if (glyph instanceof EmojiGlyph) {
                    if (emojis == null) {
                        emojis = new ArrayList<AbstractGlyphRun.PaintableEmoji>();
                    }
                    emojis.add(new AbstractGlyphRun.PaintableEmoji((EmojiGlyph)glyph, new AffineTransform(glyphTransform)));
                } else {
                    Shape glyphOutline = glyph.glyphOutline();
                    Shape renderPath = ShapeUtil.transformShape(glyphOutline, glyphTransform);
                    glyphPath.append(renderPath, false);
                }
            }
            textOutput.codepoint(codepoint, glyphTransform, context);
        }
        return new GlyphRun(glyphPath, emojis != null ? emojis : Collections.emptyList());
    }

    private static float computeBaselineOffset(@NotNull SVGFont font, @NotNull FontRenderContext fontRenderContext) {
        switch (fontRenderContext.dominantBaseline()) {
            default: {
                return font.romanBaseline();
            }
            case Hanging: {
                return font.hangingBaseline();
            }
            case Central: {
                return font.centerBaseline();
            }
            case Middle: {
                return font.middleBaseline();
            }
            case Mathematical: {
                return font.mathematicalBaseline();
            }
            case Ideographic: 
            case TextAfterEdge: 
            case TextBottom: {
                return font.textUnderBaseline();
            }
            case TextBeforeEdge: 
            case TextTop: 
        }
        return font.textOverBaseline();
    }
}

