/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http;

import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.RequestBody;
import java.io.InputStream;

public interface HttpClient {
    public <T> HttpResponse<T> execute(HttpRequest var1, Class<T> var2);

    default public <T> HttpResponse<T> get(HttpHeaders headers, String url, Class<T> responseClass) {
        HttpRequest httpRequest = new HttpRequest.Builder().url(url).httpMethod(HttpMethod.GET).headers(headers).build();
        return this.execute(httpRequest, responseClass);
    }

    default public <T> HttpResponse<T> post(HttpHeaders headers, String url, RequestBody body, Class<T> responseClass) {
        HttpRequest httpRequest = new HttpRequest.Builder().url(url).httpMethod(HttpMethod.POST).headers(headers).body(body).build();
        return this.execute(httpRequest, responseClass);
    }

    default public <T> HttpResponse<T> patch(HttpHeaders headers, String url, RequestBody body, Class<T> responseClass) {
        HttpRequest httpRequest = new HttpRequest.Builder().url(url).httpMethod(HttpMethod.PATCH).headers(headers).body(body).build();
        return this.execute(httpRequest, responseClass);
    }

    default public <T> HttpResponse<T> put(HttpHeaders headers, String url, RequestBody body, Class<T> responseClass) {
        HttpRequest httpRequest = new HttpRequest.Builder().url(url).httpMethod(HttpMethod.PUT).headers(headers).body(body).build();
        return this.execute(httpRequest, responseClass);
    }

    default public <T> HttpResponse<T> delete(HttpHeaders headers, String url, Class<T> responseClass) {
        HttpRequest httpRequest = new HttpRequest.Builder().url(url).httpMethod(HttpMethod.DELETE).headers(headers).build();
        return this.execute(httpRequest, responseClass);
    }

    public InputStream download(String var1);
}

