/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import java.util.function.Predicate;

public class MethodExclusionModule
implements Module {
    private final Predicate<MethodScope> shouldExcludeMethodsMatching;

    public static MethodExclusionModule forVoidMethods() {
        return new MethodExclusionModule(MethodScope::isVoid);
    }

    public static MethodExclusionModule forGetterMethods() {
        return new MethodExclusionModule(MethodScope::isGetter);
    }

    public static MethodExclusionModule forNonStaticNonVoidNonGetterMethods() {
        return new MethodExclusionModule(method -> !method.isStatic() && !method.isVoid() && !method.isGetter());
    }

    public MethodExclusionModule(Predicate<MethodScope> shouldExcludeMethodsMatching) {
        this.shouldExcludeMethodsMatching = shouldExcludeMethodsMatching;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forMethods().withIgnoreCheck(this.shouldExcludeMethodsMatching);
    }
}

