/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RenderCache;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HandlebarsXPathHelper
extends HandlebarsHelper<String> {
    private static final InheritableThreadLocal<XPath> localXPath = new InheritableThreadLocal<XPath>(){

        @Override
        protected XPath initialValue() {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            return xPathfactory.newXPath();
        }
    };
    private static final InheritableThreadLocal<DocumentBuilder> localDocBuilder = new InheritableThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            DocumentBuilderFactory factory = Xml.newDocumentBuilderFactory();
            try {
                return factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                return Exceptions.throwUnchecked(e, DocumentBuilder.class);
            }
        }
    };

    public Object apply(String inputXml, Options options) throws IOException {
        Document doc;
        if (inputXml == null) {
            return "";
        }
        if (options.param(0, null) == null) {
            return this.handleError("The XPath expression cannot be empty");
        }
        String xPathInput = (String)options.param(0);
        try {
            doc = this.getDocument(inputXml, options);
        }
        catch (SAXException se) {
            return this.handleError(inputXml + " is not valid XML");
        }
        try {
            Node node = this.getNode(this.getXPathPrefix() + xPathInput, doc, options);
            if (node == null) {
                return "";
            }
            return Xml.toStringValue(node);
        }
        catch (XPathExpressionException e) {
            return this.handleError(xPathInput + " is not a valid XPath expression", e);
        }
    }

    private Node getNode(String xPathExpression, Document doc, Options options) throws XPathExpressionException {
        RenderCache renderCache = HandlebarsXPathHelper.getRenderCache(options);
        RenderCache.Key cacheKey = RenderCache.Key.keyFor(Document.class, xPathExpression, doc);
        Node node = (Node)renderCache.get(cacheKey);
        if (node == null) {
            XPath xPath = (XPath)localXPath.get();
            node = (Node)xPath.evaluate(xPathExpression, doc, XPathConstants.NODE);
            renderCache.put(cacheKey, node);
        }
        return node;
    }

    private Document getDocument(String xml, Options options) throws SAXException, IOException {
        RenderCache renderCache = HandlebarsXPathHelper.getRenderCache(options);
        RenderCache.Key cacheKey = RenderCache.Key.keyFor(Document.class, xml);
        Document document = (Document)renderCache.get(cacheKey);
        if (document == null) {
            try (StringReader reader = new StringReader(xml);){
                InputSource source = new InputSource(reader);
                document = ((DocumentBuilder)localDocBuilder.get()).parse(source);
                renderCache.put(cacheKey, document);
            }
        }
        return document;
    }

    protected String getXPathPrefix() {
        return "";
    }
}

