/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoggedRequest
implements Request {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final String url;
    private final String absoluteUrl;
    private final RequestMethod method;
    private final HttpHeaders headers;
    private final String body;
    private final boolean isBrowserProxyRequest;
    private final Date loggedDate;

    public static LoggedRequest createFrom(Request request) {
        return new LoggedRequest(request.getUrl(), request.getAbsoluteUrl(), request.getMethod(), HttpHeaders.copyOf(request.getHeaders()), request.getBodyAsString(), request.isBrowserProxyRequest(), new Date());
    }

    @JsonCreator
    public LoggedRequest(@JsonProperty(value="url") String url, @JsonProperty(value="absoluteUrl") String absoluteUrl, @JsonProperty(value="method") RequestMethod method, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="body") String body, @JsonProperty(value="browserProxyRequest") boolean isBrowserProxyRequest, @JsonProperty(value="loggedDate") Date loggedDate) {
        this.url = url;
        this.absoluteUrl = absoluteUrl;
        this.method = method;
        this.body = body;
        this.headers = headers;
        this.isBrowserProxyRequest = isBrowserProxyRequest;
        this.loggedDate = loggedDate;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    @JsonIgnore
    public String getHeader(String key) {
        HttpHeader header = this.header(key);
        if (header.isPresent()) {
            return header.firstValue();
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        return this.headers.getHeader(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.headers.getContentTypeHeader();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.getHeader(key) != null;
    }

    @Override
    @JsonProperty(value="body")
    public String getBodyAsString() {
        return this.body;
    }

    @Override
    @JsonIgnore
    public Set<String> getAllHeaderKeys() {
        return this.headers.keys();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.isBrowserProxyRequest;
    }

    public Date getLoggedDate() {
        return this.loggedDate;
    }

    public String getLoggedDateString() {
        return this.format(this.loggedDate);
    }

    private String format(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }
}

