/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;
import wiremock.com.github.jknack.handlebars.Template;
import wiremock.com.github.jknack.handlebars.internal.Files;

public enum JSEngine {
    RHINO{

        @Override
        public String toJavaScript(String hbslocation, Template template) {
            return this.toJavaScript(hbslocation, template.filename(), template.text());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toJavaScript(String hbslocation, String filename, String template) {
            Context ctx = null;
            try {
                ctx = this.newContext();
                Scriptable scope = this.newScope(hbslocation, ctx);
                scope.put("template", scope, (Object)template);
                String js = "Handlebars.precompile(template);";
                Object precompiled = ctx.evaluateString(scope, js, filename, 1, null);
                String string = (String)precompiled;
                return string;
            }
            finally {
                if (ctx != null) {
                    Context.exit();
                }
            }
        }

        private Scriptable newScope(String hbslocation, Context ctx) {
            Scriptable sharedScope = this.sharedScope(hbslocation, ctx);
            Scriptable scope = ctx.newObject(sharedScope);
            scope.setParentScope(null);
            scope.setPrototype(sharedScope);
            return scope;
        }

        private Context newContext() {
            Context ctx = Context.enter();
            ctx.setOptimizationLevel(-1);
            ctx.setErrorReporter((ErrorReporter)new ToolErrorReporter(false));
            ctx.setLanguageVersion(180);
            return ctx;
        }

        private Scriptable sharedScope(String hbslocation, Context ctx) {
            ScriptableObject sharedScope = ctx.initStandardObjects();
            ctx.evaluateString((Scriptable)sharedScope, this.handlebarsScript(hbslocation), hbslocation, 1, null);
            return sharedScope;
        }

        private String handlebarsScript(String location) {
            try {
                return Files.read(location, StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Unable to read file: " + location, ex);
            }
        }
    };


    public abstract String toJavaScript(String var1, Template var2);

    public abstract String toJavaScript(String var1, String var2, String var3);
}

