/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.proto.mapper;

import com.github.tobato.fastdfs.proto.mapper.BytesUtil;
import com.github.tobato.fastdfs.proto.mapper.DynamicFieldType;
import com.github.tobato.fastdfs.proto.mapper.FdfsColumn;
import com.github.tobato.fastdfs.proto.mapper.FdfsColumnMapException;
import com.github.tobato.fastdfs.proto.mapper.MetadataMapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;

class FieldMataData {
    private Field field;
    private int index;
    private int max;
    private int size;
    private int offsize;
    DynamicFieldType dynamicFieldType;

    public FieldMataData(Field mapedfield, int offsize) {
        FdfsColumn column = mapedfield.getAnnotation(FdfsColumn.class);
        this.field = mapedfield;
        this.index = column.index();
        this.max = column.max();
        this.size = this.getFieldSize(this.field);
        this.offsize = offsize;
        this.dynamicFieldType = column.dynamicField();
        if (this.max > 0 && this.size > this.max) {
            this.size = this.max;
        }
    }

    private int getFieldSize(Field field) {
        if (String.class == field.getType()) {
            return this.max;
        }
        if (Long.TYPE == field.getType()) {
            return 8;
        }
        if (Integer.TYPE == field.getType()) {
            return 8;
        }
        if (Date.class == field.getType()) {
            return 8;
        }
        if (Byte.TYPE == field.getType()) {
            return 1;
        }
        if (Boolean.TYPE == field.getType()) {
            return 1;
        }
        if (Set.class == field.getType()) {
            return 0;
        }
        throw new FdfsColumnMapException(field.getName() + "\u83b7\u53d6Field\u5927\u5c0f\u65f6\u672a\u8bc6\u522b\u7684FdfsColumn\u7c7b\u578b" + field.getType());
    }

    public Object getValue(byte[] bs, Charset charset) {
        if (String.class == this.field.getType()) {
            if (this.isDynamicField()) {
                return new String(bs, this.offsize, bs.length - this.offsize, charset).trim();
            }
            return new String(bs, this.offsize, this.size, charset).trim();
        }
        if (Long.TYPE == this.field.getType()) {
            return BytesUtil.buff2long(bs, this.offsize);
        }
        if (Integer.TYPE == this.field.getType()) {
            return (int)BytesUtil.buff2long(bs, this.offsize);
        }
        if (Date.class == this.field.getType()) {
            return new java.sql.Date(BytesUtil.buff2long(bs, this.offsize) * 1000L);
        }
        if (Byte.TYPE == this.field.getType()) {
            return bs[this.offsize];
        }
        if (Boolean.TYPE == this.field.getType()) {
            return bs[this.offsize] != 0;
        }
        throw new FdfsColumnMapException(this.field.getName() + "\u83b7\u53d6\u503c\u65f6\u672a\u8bc6\u522b\u7684FdfsColumn\u7c7b\u578b" + this.field.getType());
    }

    public Field getField() {
        return this.field;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMax() {
        return this.max;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public int getSize() {
        return this.size;
    }

    public int getRealeSize() {
        if (this.isDynamicField()) {
            return 0;
        }
        return this.size;
    }

    public int getOffsize() {
        return this.offsize;
    }

    public String toString() {
        return "FieldMataData [field=" + this.getFieldName() + ", index=" + this.index + ", max=" + this.max + ", size=" + this.size + ", offsize=" + this.offsize + "]";
    }

    public byte[] toByte(Object bean, Charset charset) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = this.getFieldValue(bean);
        if (this.isDynamicField()) {
            return this.getDynamicFieldByteValue(value, charset);
        }
        if (String.class.equals(this.field.getType())) {
            return BytesUtil.objString2Byte((String)value, this.max, charset);
        }
        if (Long.TYPE.equals(this.field.getType())) {
            return BytesUtil.long2buff((Long)value);
        }
        if (Integer.TYPE.equals(this.field.getType())) {
            return BytesUtil.long2buff(((Integer)value).intValue());
        }
        if (java.sql.Date.class.equals(this.field.getType())) {
            throw new FdfsColumnMapException("Date \u8fd8\u4e0d\u652f\u6301");
        }
        if (Byte.TYPE.equals(this.field.getType())) {
            byte[] result = new byte[]{(Byte)value};
            return result;
        }
        if (Boolean.TYPE.equals(this.field.getType())) {
            throw new FdfsColumnMapException("boolean \u8fd8\u4e0d\u652f\u6301");
        }
        throw new FdfsColumnMapException("\u5c06\u5c5e\u6027\u503c\u8f6c\u6362\u4e3abyte\u65f6\u672a\u8bc6\u522b\u7684FdfsColumn\u7c7b\u578b" + this.field.getName());
    }

    private byte[] getDynamicFieldByteValue(Object value, Charset charset) {
        switch (this.dynamicFieldType) {
            case allRestByte: {
                return BytesUtil.objString2Byte((String)value, charset);
            }
            case matadata: {
                return MetadataMapper.toByte((Set)value, charset);
            }
        }
        return BytesUtil.objString2Byte((String)value, charset);
    }

    private Object getFieldValue(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return PropertyUtils.getProperty((Object)bean, (String)this.field.getName());
    }

    public int getDynamicFieldByteSize(Object bean, Charset charset) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getProperty((Object)bean, (String)this.field.getName());
        if (null == value) {
            return 0;
        }
        switch (this.dynamicFieldType) {
            case allRestByte: {
                return ((String)value).getBytes(charset).length;
            }
            case matadata: {
                return MetadataMapper.toByte((Set)value, charset).length;
            }
        }
        return this.getFieldSize(this.field);
    }

    public boolean isDynamicField() {
        return !DynamicFieldType.NULL.equals((Object)this.dynamicFieldType);
    }
}

