/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.proto;

import com.github.tobato.fastdfs.proto.ProtoHead;
import com.github.tobato.fastdfs.proto.mapper.FdfsParamMapper;
import com.github.tobato.fastdfs.proto.mapper.ObjectMataData;
import java.io.InputStream;
import java.nio.charset.Charset;

public abstract class FdfsRequest {
    protected ProtoHead head;
    protected InputStream inputFile;

    ProtoHead getHead() {
        return this.head;
    }

    public byte[] getHeadByte(Charset charset) {
        this.head.setContentLength(this.getBodyLength(charset));
        return this.head.toByte();
    }

    public byte[] encodeParam(Charset charset) {
        return FdfsParamMapper.toByte(this, charset);
    }

    protected long getBodyLength(Charset charset) {
        ObjectMataData objectMataData = FdfsParamMapper.getObjectMap(this.getClass());
        return (long)objectMataData.getFieldsSendTotalByteSize(this, charset) + this.getFileSize();
    }

    public InputStream getInputFile() {
        return this.inputFile;
    }

    public long getFileSize() {
        return 0L;
    }
}

