/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrick.template.JetEngine;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.JetTemplate;
import jetbrick.template.JetTemplateMacro;
import jetbrick.template.parser.Source;
import jetbrick.template.resolver.GlobalResolver;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.JetWriter;
import jetbrick.template.runtime.TemplateStack;
import jetbrick.template.runtime.ValueStack;

public final class InterpretContextImpl
extends InterpretContext {
    private final JetEngine engine;
    private final GlobalResolver globalResolver;
    private final TemplateStack templateStack;
    private final ValueStack valueStack;
    private JetSecurityManager securityManager;
    private JetWriter writer;
    private int signal;
    private String returnName;

    public InterpretContextImpl(JetEngine engine, JetWriter writer, Map<String, Object> context, JetSecurityManager securityManager) {
        this.engine = engine;
        this.globalResolver = engine.getGlobalResolver();
        this.securityManager = securityManager;
        this.templateStack = new TemplateStack();
        this.valueStack = new ValueStack(engine.getGlobalContext(), context);
        this.writer = writer;
        this.signal = 0;
        this.setThreadLocal();
    }

    public void setThreadLocal() {
        threadLocal.set(this);
    }

    public void freeThreadLocal() {
        threadLocal.remove();
    }

    @Override
    public JetEngine getEngine() {
        return this.engine;
    }

    @Override
    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }

    @Override
    public JetSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public TemplateStack getTemplateStack() {
        return this.templateStack;
    }

    @Override
    public ValueStack getValueStack() {
        return this.valueStack;
    }

    @Override
    public JetTemplate getTemplate() {
        return this.templateStack.current();
    }

    @Override
    public Source getSource() {
        return this.templateStack.current().getSource();
    }

    @Override
    public JetWriter getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(JetWriter writer) {
        this.writer = writer;
    }

    @Override
    public int getSignal() {
        return this.signal;
    }

    @Override
    public void setSignal(int signal) {
        this.signal = signal;
    }

    @Override
    public String getReturnName() {
        return this.returnName;
    }

    @Override
    public void doIncludeCall(String file, Map<String, Object> arguments, String returnName) {
        JetTemplate template = this.engine.getTemplate(file);
        this.returnName = returnName;
        this.securityManager = template.getSecurityManager();
        this.templateStack.push(template);
        this.valueStack.push(template.getOption().getSymbols(), arguments, true);
        JetWriter originWriter = this.writer;
        this.setWriter(JetWriter.create(this.writer, template.getOption().isTrimLeadingWhitespaces()));
        template.getAstNode().execute(this);
        this.setWriter(originWriter);
        this.valueStack.pop();
        this.templateStack.pop();
        this.securityManager = this.templateStack.current().getSecurityManager();
        this.returnName = null;
    }

    @Override
    public void doMacroCall(JetTemplateMacro macro, Object[] arguments) {
        HashMap<String, Object> args;
        boolean isCrossTemplate;
        List<String> names = macro.getArgumentNames();
        if (names.size() != arguments.length) {
            throw new IllegalArgumentException("macro arguments do not match: " + macro.getName());
        }
        boolean bl = isCrossTemplate = this.templateStack.current() != macro.getTemplate();
        if (isCrossTemplate) {
            macro.getTemplate().reload();
            this.templateStack.push(macro.getTemplate());
            this.securityManager = this.templateStack.current().getSecurityManager();
        }
        if (arguments == null || arguments.length == 0) {
            args = null;
        } else {
            args = new HashMap<String, Object>();
            for (int i = 0; i < arguments.length; ++i) {
                args.put(names.get(i), arguments[i]);
            }
        }
        this.valueStack.push(macro.getSymbols(), args, true);
        macro.getAstNode().execute(this);
        this.valueStack.pop();
        if (isCrossTemplate) {
            this.templateStack.pop();
            this.securityManager = this.templateStack.current().getSecurityManager();
        }
    }
}

