/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import jetbrick.bean.MethodInfo;
import jetbrick.io.finder.ClassFinder;
import jetbrick.template.JetAnnotations;
import jetbrick.template.JetTemplate;
import jetbrick.template.JetTemplateMacro;
import jetbrick.template.TemplateException;
import jetbrick.template.resolver.clazz.ClassResolver;
import jetbrick.template.resolver.function.FunctionInvoker;
import jetbrick.template.resolver.function.FunctionInvokerResolver;
import jetbrick.template.resolver.macro.MacroResolver;
import jetbrick.template.resolver.method.MethodInvoker;
import jetbrick.template.resolver.method.MethodInvokerResolver;
import jetbrick.template.resolver.property.DefaultGetterResolver;
import jetbrick.template.resolver.property.Getter;
import jetbrick.template.resolver.property.GetterResolver;
import jetbrick.template.resolver.tag.TagInvoker;
import jetbrick.template.resolver.tag.TagInvokerResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalResolver {
    private static final Logger log = LoggerFactory.getLogger(GlobalResolver.class);
    private final ClassResolver classResolver = new ClassResolver(true);
    private final DefaultGetterResolver defaultGetterResolver = new DefaultGetterResolver();
    private final MethodInvokerResolver methodInvokerResolver = new MethodInvokerResolver();
    private final FunctionInvokerResolver functionInvokerResolver = new FunctionInvokerResolver();
    private final TagInvokerResolver tagInvokerResolver = new TagInvokerResolver();
    private final MacroResolver macroResolver = new MacroResolver();

    public void scan(List<String> packageNames, boolean skipErrors) {
        List<Class> annotations = Arrays.asList(JetAnnotations.Methods.class, JetAnnotations.Functions.class, JetAnnotations.Tags.class);
        log.info("Scanning @JetMethods, @JetFunctions, @JetTags implements from " + packageNames + " ...");
        long ts = System.currentTimeMillis();
        Set classes = ClassFinder.getClasses(packageNames, (boolean)true, annotations, (boolean)skipErrors);
        log.info("Found {} annotated classes, time elapsed {} ms.", (Object)classes.size(), (Object)(System.currentTimeMillis() - ts));
        for (Class cls : classes) {
            for (Annotation anno : cls.getAnnotations()) {
                if (anno instanceof JetAnnotations.Methods) {
                    this.registerMethods(cls);
                    continue;
                }
                if (anno instanceof JetAnnotations.Functions) {
                    this.registerFunctions(cls);
                    continue;
                }
                if (!(anno instanceof JetAnnotations.Tags)) continue;
                this.registerTags(cls);
            }
        }
    }

    public void importClass(String name) {
        this.classResolver.importClass(name);
    }

    public void registerGetterResolver(GetterResolver resolver) {
        this.defaultGetterResolver.register(resolver);
    }

    public void registerMethods(String className) {
        Class<?> cls = this.resolveClass(className);
        if (cls == null) {
            throw new TemplateException("@JetMethods class not found: " + className);
        }
        this.methodInvokerResolver.register(cls);
    }

    public void registerMethods(Class<?> cls) {
        this.methodInvokerResolver.register(cls);
    }

    public void registerMethod(MethodInfo method) {
        this.methodInvokerResolver.register(method);
    }

    public void registerFunctions(String className) {
        Class<?> cls = this.resolveClass(className);
        if (cls == null) {
            throw new TemplateException("@JetFunctions class not found: " + className);
        }
        this.functionInvokerResolver.register(cls);
    }

    public void registerFunctions(Class<?> cls) {
        this.functionInvokerResolver.register(cls);
    }

    public void registerFunction(MethodInfo method) {
        this.functionInvokerResolver.register(method);
    }

    public void registerTags(String className) {
        Class<?> cls = this.resolveClass(className);
        if (cls == null) {
            throw new TemplateException("@JetTags class not found: " + className);
        }
        this.tagInvokerResolver.register(cls);
    }

    public void registerTags(Class<?> cls) {
        this.tagInvokerResolver.register(cls);
    }

    public void registerTag(MethodInfo method) {
        this.tagInvokerResolver.register(method);
    }

    public void registerMacros(JetTemplate template) {
        this.macroResolver.register(template);
    }

    public Class<?> resolveClass(String name) {
        return this.classResolver.resolveClass(name);
    }

    public MethodInvoker resolveMethod(Class<?> clazz, String name, Class<?>[] argumentTypes, boolean isStatic) {
        return this.methodInvokerResolver.resolve(clazz, name, argumentTypes, isStatic);
    }

    public FunctionInvoker resolveFunction(String name, Class<?>[] argumentTypes) {
        return this.functionInvokerResolver.resolve(name, argumentTypes);
    }

    public TagInvoker resolveTag(String name, Class<?>[] argumentTypes) {
        return this.tagInvokerResolver.resolve(name, argumentTypes);
    }

    public JetTemplateMacro resolveMacro(String name, Class<?>[] argumentTypes, boolean reloadable) {
        return this.macroResolver.resolve(name, argumentTypes, reloadable);
    }

    public Getter resolveGetter(Class<?> objectClass, String name) {
        return this.defaultGetterResolver.resolve(objectClass, name);
    }
}

