/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import java.lang.reflect.Array;
import java.util.List;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;

public final class AstInvokeNewArray
extends AstExpression {
    private final Class<?> cls;
    private final AstExpression[] expressions;
    private boolean unsafe;

    public AstInvokeNewArray(Class<?> cls, List<AstExpression> expressions, Position position) {
        super(position);
        this.cls = cls;
        this.expressions = expressions.toArray(new AstExpression[0]);
        this.unsafe = true;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        int length;
        if (this.unsafe) {
            JetSecurityManager securityManager = ctx.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkAccess(this.cls);
                }
                catch (RuntimeException e) {
                    throw new InterpretException(e).set(this.position);
                }
            }
            this.unsafe = false;
        }
        if ((length = this.expressions.length) == 1) {
            Object size = this.expressions[0].execute(ctx);
            this.validate(ctx, 0, size);
            return Array.newInstance(this.cls, ((Number)size).intValue());
        }
        int[] dimensions = new int[length];
        for (int i = 0; i < length; ++i) {
            Object size = this.expressions[i].execute(ctx);
            this.validate(ctx, i, size);
            dimensions[i] = ((Number)size).intValue();
        }
        return Array.newInstance(this.cls, dimensions);
    }

    private void validate(InterpretContext ctx, int index, Object o) {
        if (o == null) {
            throw new InterpretException("array length is null").set(this.expressions[index].getPosition());
        }
        Class<?> cls = o.getClass();
        if (cls == Integer.class || cls == Short.class || cls == Byte.class) {
            return;
        }
        throw new InterpretException("type mismatch: the %s argument cannot convert from %s to %s", index, cls.getName(), "int").set(this.expressions[index].getPosition());
    }
}

