/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.Errors;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.parser.ast.ALU;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.AstExpressionList;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.resolver.ParameterUtils;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.resolver.method.MethodInvoker;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.util.ArrayUtils;

public final class AstInvokeMethodStatic
extends AstExpression {
    private final Class<?> cls;
    private final String name;
    private final AstExpressionList argumentList;
    private MethodInvoker last;
    private boolean unsafe;

    public AstInvokeMethodStatic(Class<?> cls, String name, AstExpressionList argumentList, Position position) {
        super(position);
        this.cls = cls;
        this.name = name;
        this.argumentList = argumentList;
        this.last = null;
        this.unsafe = true;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        Object[] arguments = this.argumentList == null ? ArrayUtils.EMPTY_OBJECT_ARRAY : this.argumentList.execute(ctx);
        return this.doInvoke(ctx, this.last, arguments);
    }

    private Object doInvoke(InterpretContext ctx, MethodInvoker invoker, Object[] arguments) throws InterpretException {
        boolean useLatest;
        boolean bl = useLatest = invoker != null;
        if (invoker == null) {
            Class<?>[] argumentTypes = ParameterUtils.getParameterTypes(arguments);
            invoker = ctx.getGlobalResolver().resolveMethod(this.cls, this.name, argumentTypes, true);
            if (invoker == null) {
                String signature = SignatureUtils.getMethodSignature(this.cls, this.name, argumentTypes);
                throw new InterpretException("cannot resolve static method: %s", signature).set(this.position);
            }
            this.last = invoker;
        }
        if (this.unsafe) {
            JetSecurityManager securityManager = ctx.getSecurityManager();
            if (securityManager != null) {
                try {
                    invoker.checkAccess(securityManager);
                }
                catch (RuntimeException e) {
                    throw new InterpretException(e).set(this.position);
                }
            }
            this.unsafe = false;
        }
        try {
            Object result = invoker.invoke(null, arguments);
            if (result != null) {
                return result;
            }
            return invoker.isVoidResult() ? ALU.VOID : null;
        }
        catch (RuntimeException e) {
            if (useLatest && Errors.isReflectIllegalArgumentException(e)) {
                return this.doInvoke(ctx, null, arguments);
            }
            throw new InterpretException("static method invoke error: %s", invoker.getSignature()).cause(e).set(this.position);
        }
    }
}

