/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import java.util.Collections;
import java.util.Map;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.template.parser.ast.AstDirective;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.util.PathUtils;

public final class AstDirectiveInclude
extends AstDirective {
    private final AstExpression fileExpression;
    private final AstExpression parametersExpression;
    private final String returnName;

    public AstDirectiveInclude(AstExpression fileExpression, AstExpression parametersExpression, String returnName, Position position) {
        super(position);
        this.fileExpression = fileExpression;
        this.parametersExpression = parametersExpression;
        this.returnName = returnName;
    }

    @Override
    public void execute(InterpretContext ctx) throws InterpretException {
        Object parameters;
        Object file = this.fileExpression.execute(ctx);
        if (file == null) {
            throw new InterpretException("the %s argument is null", "1st").set(this.fileExpression.getPosition());
        }
        if (!(file instanceof String)) {
            throw new InterpretException("type mismatch: the %s argument cannot convert from %s to %s", "1st", file.getClass(), "String").set(this.fileExpression.getPosition());
        }
        if (this.parametersExpression == null) {
            parameters = Collections.emptyMap();
        } else {
            parameters = this.parametersExpression.execute(ctx);
            if (parameters == null) {
                parameters = Collections.emptyMap();
            } else if (!(parameters instanceof Map)) {
                throw new InterpretException("type mismatch: the %s argument cannot convert from %s to %s", "2nd", parameters.getClass(), "Map<String, Object>").set(this.parametersExpression.getPosition());
            }
        }
        try {
            String fileName = PathUtils.getRelativePath((String)ctx.getTemplate().getName(), (String)((String)file));
            ctx.doIncludeCall(fileName, (Map<String, Object>)parameters, this.returnName);
        }
        catch (ResourceNotFoundException e) {
            throw new InterpretException("include file not found: %s", file).set(this.fileExpression.getPosition());
        }
    }
}

