/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import java.util.List;
import jetbrick.collection.ListMap;
import jetbrick.template.parser.ast.AstConstantMapEntry;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.util.tuple.NameValuePair;

public final class AstConstantMap
extends AstExpression {
    private static final AstConstantMapEntry[] EMPTY_ARRAY = new AstConstantMapEntry[0];
    private final AstConstantMapEntry[] entries;

    public AstConstantMap(List<AstConstantMapEntry> entries, Position position) {
        super(position);
        this.entries = entries.toArray(EMPTY_ARRAY);
    }

    @Override
    public Object execute(InterpretContext ctx) {
        ListMap map = new ListMap(this.entries.length);
        for (AstConstantMapEntry entry : this.entries) {
            NameValuePair<String, Object> pair = entry.execute(ctx);
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }
}

